/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import com.vaadin.cdi.annotation.UIScoped;
import com.vaadin.cdi.annotation.VaadinSessionScoped;
import com.vaadin.cdi.context.AbstractContextualStorageManager;
import com.vaadin.cdi.util.AbstractContext;
import com.vaadin.cdi.util.BeanProvider;
import com.vaadin.cdi.util.ContextualStorage;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;

public class UIScopedContext
extends AbstractContext {
    private ContextualStorageManager contextualStorageManager;

    public UIScopedContext(BeanManager beanManager) {
        super(beanManager);
    }

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        return this.contextualStorageManager.getContextualStorage(createIfNotExist);
    }

    public void init(BeanManager beanManager) {
        this.contextualStorageManager = BeanProvider.getContextualReference(beanManager, ContextualStorageManager.class, false, new Annotation[0]);
    }

    public Class<? extends Annotation> getScope() {
        return UIScoped.class;
    }

    public boolean isActive() {
        return VaadinSession.getCurrent() != null && UI.getCurrent() != null && this.contextualStorageManager != null;
    }

    @VaadinSessionScoped
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<Integer> {
        public ContextualStorageManager() {
            super(false);
        }

        public ContextualStorage getContextualStorage(boolean createIfNotExist) {
            Integer uiId = UI.getCurrent().getUIId();
            return super.getContextualStorage(uiId, createIfNotExist);
        }

        @Override
        protected ContextualStorage newContextualStorage(Integer uiId) {
            UI.getCurrent().addDetachListener(this::destroy);
            return super.newContextualStorage(uiId);
        }

        @Override
        private void destroy(DetachEvent event) {
            int uiId = event.getUI().getUIId();
            super.destroy(uiId);
        }
    }
}

