/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import com.vaadin.cdi.annotation.VaadinSessionScoped;
import com.vaadin.cdi.util.AbstractContext;
import com.vaadin.cdi.util.ContextUtils;
import com.vaadin.cdi.util.ContextualStorage;
import com.vaadin.flow.server.VaadinSession;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;

public class VaadinSessionScopedContext
extends AbstractContext {
    private final BeanManager beanManager;
    private static final String ATTRIBUTE_NAME = VaadinSessionScopedContext.class.getName();

    public VaadinSessionScopedContext(BeanManager beanManager) {
        super(beanManager);
        this.beanManager = beanManager;
    }

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        VaadinSession session = VaadinSession.getCurrent();
        ContextualStorage storage = VaadinSessionScopedContext.findContextualStorage(session);
        if (storage == null && createIfNotExist) {
            storage = new ContextualStorage(this.beanManager, false, true);
            session.setAttribute(ATTRIBUTE_NAME, (Object)storage);
        }
        return storage;
    }

    private static ContextualStorage findContextualStorage(VaadinSession session) {
        return (ContextualStorage)session.getAttribute(ATTRIBUTE_NAME);
    }

    public Class<? extends Annotation> getScope() {
        return VaadinSessionScoped.class;
    }

    public boolean isActive() {
        return VaadinSession.getCurrent() != null;
    }

    public static void destroy(VaadinSession session) {
        ContextualStorage storage = VaadinSessionScopedContext.findContextualStorage(session);
        if (storage != null) {
            AbstractContext.destroyAllActive(storage);
        }
    }

    public static boolean guessContextIsUndeployed() {
        return VaadinSession.getCurrent() != null && !ContextUtils.isContextActive(VaadinSessionScoped.class);
    }
}

