/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.BeanLookup;
import com.vaadin.cdi.CdiInstantiator;
import com.vaadin.cdi.util.BeanProvider;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.auth.MenuAccessControl;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCdiInstantiator
implements Instantiator {
    private static final String CANNOT_USE_CDI_BEANS_FOR_I18N = "Cannot use CDI beans for I18N, falling back to the default behavior.";
    private static final String FALLING_BACK_TO_DEFAULT_INSTANTIATION = "Falling back to default instantiation.";
    private AtomicBoolean i18NLoggingEnabled = new AtomicBoolean(true);

    protected abstract DefaultInstantiator getDelegate();

    public abstract BeanManager getBeanManager();

    public <T> T getOrCreate(Class<T> type) {
        return (T)new BeanLookup<T>(this.getBeanManager(), type, new Annotation[0]).setUnsatisfiedHandler(() -> AbstractCdiInstantiator.getLogger().debug("'{}' is not a CDI bean. Falling back to default instantiation.", (Object)type.getName())).setAmbiguousHandler(e -> AbstractCdiInstantiator.getLogger().debug("Multiple CDI beans found. Falling back to default instantiation.", (Throwable)e)).lookupOrElseGet(() -> {
            Object instance = this.getDelegate().getOrCreate(type);
            BeanProvider.injectFields(instance);
            return instance;
        });
    }

    public I18NProvider getI18NProvider() {
        BeanLookup<I18NProvider> lookup = new BeanLookup<I18NProvider>(this.getBeanManager(), I18NProvider.class, BeanLookup.SERVICE);
        if (this.i18NLoggingEnabled.compareAndSet(true, false)) {
            lookup.setUnsatisfiedHandler(() -> AbstractCdiInstantiator.getLogger().info("Can't find any @VaadinServiceScoped bean implementing '{}'. Cannot use CDI beans for I18N, falling back to the default behavior.", (Object)I18NProvider.class.getSimpleName())).setAmbiguousHandler(e -> AbstractCdiInstantiator.getLogger().warn("Found more beans for I18N. Cannot use CDI beans for I18N, falling back to the default behavior.", (Throwable)e));
        } else {
            lookup.setAmbiguousHandler(e -> {});
        }
        return lookup.lookupOrElseGet(() -> ((DefaultInstantiator)this.getDelegate()).getI18NProvider());
    }

    public MenuAccessControl getMenuAccessControl() {
        BeanLookup<MenuAccessControl> lookup = new BeanLookup<MenuAccessControl>(this.getBeanManager(), MenuAccessControl.class, BeanLookup.SERVICE);
        return lookup.lookupOrElseGet(() -> ((DefaultInstantiator)this.getDelegate()).getMenuAccessControl());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CdiInstantiator.class);
    }

    public Stream<VaadinServiceInitListener> getServiceInitListeners() {
        return Stream.concat(this.getDelegate().getServiceInitListeners(), Stream.of((VaadinServiceInitListener & Serializable)serviceInitEvent -> this.getBeanManager().getEvent().fire((Object)serviceInitEvent)));
    }
}

