/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.BeanLookup;
import com.vaadin.cdi.CdiVaadinServlet;
import com.vaadin.cdi.VaadinTaskExecutorSelector;
import com.vaadin.cdi.annotation.VaadinServiceScoped;
import com.vaadin.cdi.context.VaadinSessionScopedContext;
import com.vaadin.cdi.util.BeanManagerProvider;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.PollEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SystemMessagesProvider;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiVaadinServletService
extends VaadinServletService {
    private final CdiVaadinServiceDelegate delegate;

    public CdiVaadinServletService(CdiVaadinServlet servlet, DeploymentConfiguration configuration, BeanManager beanManager) {
        super((VaadinServlet)servlet, configuration);
        this.delegate = new CdiVaadinServiceDelegate(beanManager);
    }

    public void init() throws ServiceException {
        this.delegate.init((VaadinService)this);
        super.init();
    }

    public void fireUIInitListeners(UI ui) {
        this.delegate.addUIListeners(ui);
        super.fireUIInitListeners(ui);
    }

    protected VaadinSession loadSession(WrappedSession wrappedSession) {
        return super.loadSession(wrappedSession);
    }

    protected void storeSession(VaadinSession session, WrappedSession wrappedSession) {
        super.storeSession(session, wrappedSession);
    }

    private void restoreDelegate(VaadinSession session) {
    }

    protected Executor createDefaultExecutor() {
        Instance instance = this.delegate.getBeanManager().createInstance().select(VaadinTaskExecutorSelector.class, new Annotation[0]);
        VaadinTaskExecutorSelector selector = (VaadinTaskExecutorSelector)instance.get();
        Executor executor = selector.getExecutor().orElseGet(() -> super.createDefaultExecutor());
        instance.destroy((Object)selector);
        return executor;
    }

    public Optional<Instantiator> loadInstantiators() throws ServiceException {
        Bean bean;
        BeanManager beanManager = this.delegate.getBeanManager();
        Set beans = beanManager.getBeans(InstantiatorFactory.class, new Annotation[]{BeanLookup.SERVICE});
        if (beans == null || beans.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because no CDI instantiator factory bean found.");
        }
        try {
            bean = beanManager.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            throw new ServiceException("There are multiple eligible CDI " + InstantiatorFactory.class.getSimpleName() + " beans.", (Throwable)e);
        }
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Context context = beanManager.getContext(VaadinServiceScoped.class);
        InstantiatorFactory instantiatorFactory = (InstantiatorFactory)context.get((Contextual)bean, creationalContext);
        Instantiator instantiator = instantiatorFactory.createInstantitor((VaadinService)this);
        if (instantiator == null) {
            throw new ServiceException("Cannot init VaadinService because  no Instantiator is available. Please check your  InstatiatorFactory CDI bean implementation.");
        }
        return Optional.of(instantiator);
    }

    public CdiVaadinServlet getServlet() {
        return (CdiVaadinServlet)super.getServlet();
    }

    public static class CdiVaadinServiceDelegate
    implements Serializable {
        private transient BeanManager beanManager;
        private final UIEventListener uiEventListener;

        public CdiVaadinServiceDelegate(BeanManager beanManager) {
            this.beanManager = beanManager;
            this.uiEventListener = new UIEventListener(this);
        }

        public void init(VaadinService vaadinService) throws ServiceException {
            this.lookup(SystemMessagesProvider.class).ifPresent(arg_0 -> ((VaadinService)vaadinService).setSystemMessagesProvider(arg_0));
            vaadinService.addUIInitListener((UIInitListener & Serializable)e -> this.getBeanManager().getEvent().fire((Object)e));
            vaadinService.addSessionInitListener(this::sessionInit);
            vaadinService.addSessionDestroyListener(this::sessionDestroy);
            vaadinService.addServiceDestroyListener(this::fireCdiDestroyEvent);
        }

        public void addUIListeners(UI ui) {
            ui.addAfterNavigationListener((AfterNavigationListener)this.uiEventListener);
            ui.addBeforeLeaveListener((BeforeLeaveListener)this.uiEventListener);
            ui.addBeforeEnterListener((BeforeEnterListener)this.uiEventListener);
            ui.addPollListener((ComponentEventListener)this.uiEventListener);
        }

        public <T> Optional<T> lookup(Class<T> type) throws ServiceException {
            try {
                T instance = new BeanLookup<T>(this.getBeanManager(), type, BeanLookup.SERVICE).lookup();
                return Optional.ofNullable(instance);
            }
            catch (AmbiguousResolutionException e) {
                throw new ServiceException("There are multiple eligible CDI " + type.getSimpleName() + " beans.", (Throwable)e);
            }
        }

        public BeanManager getBeanManager() {
            if (this.beanManager == null) {
                this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
            }
            return this.beanManager;
        }

        private void sessionInit(SessionInitEvent sessionInitEvent) throws ServiceException {
            VaadinSession session = sessionInitEvent.getSession();
            this.lookup(ErrorHandler.class).ifPresent(arg_0 -> ((VaadinSession)session).setErrorHandler(arg_0));
            this.getBeanManager().getEvent().fire((Object)sessionInitEvent);
        }

        private void sessionDestroy(SessionDestroyEvent sessionDestroyEvent) {
            this.getBeanManager().getEvent().fire((Object)sessionDestroyEvent);
            if (VaadinSessionScopedContext.guessContextIsUndeployed()) {
                CdiVaadinServiceDelegate.getLogger().warn("VaadinSessionScoped context does not exist. Maybe application is undeployed. Can't destroy VaadinSessionScopedContext.");
                return;
            }
            CdiVaadinServiceDelegate.getLogger().debug("VaadinSessionScopedContext destroy");
            VaadinSessionScopedContext.destroy(sessionDestroyEvent.getSession());
        }

        private void fireCdiDestroyEvent(ServiceDestroyEvent event) {
            try {
                this.getBeanManager().getEvent().fire((Object)event);
            }
            catch (Exception e) {
                CdiVaadinServiceDelegate.getLogger().warn("Error at destroy event distribution with CDI.", (Throwable)e);
            }
        }

        private static Logger getLogger() {
            return LoggerFactory.getLogger(CdiVaadinServiceDelegate.class);
        }
    }

    @ListenerPriority(value=-100)
    private static class UIEventListener
    implements AfterNavigationListener,
    BeforeEnterListener,
    BeforeLeaveListener,
    ComponentEventListener<PollEvent> {
        private final CdiVaadinServiceDelegate delegate;

        private UIEventListener(CdiVaadinServiceDelegate delegate) {
            this.delegate = delegate;
        }

        public void afterNavigation(AfterNavigationEvent event) {
            this.delegate.getBeanManager().getEvent().fire((Object)event);
        }

        public void beforeEnter(BeforeEnterEvent event) {
            this.delegate.getBeanManager().getEvent().fire((Object)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            this.delegate.getBeanManager().getEvent().fire((Object)event);
        }

        public void onComponentEvent(PollEvent event) {
            this.delegate.getBeanManager().getEvent().fire((Object)event);
        }
    }
}

