/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.annotation.VaadinServiceEnabled;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

class VaadinTaskExecutorSelector {
    @Inject
    BeanManager beanManager;
    @Inject
    @VaadinServiceEnabled
    Instance<Executor> customExecutor;

    VaadinTaskExecutorSelector() {
    }

    Optional<Executor> getExecutor() {
        if (this.customExecutor.isResolvable()) {
            LoggerFactory.getLogger(VaadinTaskExecutorSelector.class).debug("Using custom Vaadin Executor {}", (Object)this.customExecutor.getHandle().getBean());
            return Optional.of((Executor)this.customExecutor.get());
        }
        if (this.customExecutor.isAmbiguous()) {
            String candidates = this.customExecutor.handlesStream().map(handle -> handle.getBean().toString()).collect(Collectors.joining(", ", "[", "]"));
            String message = String.format("Multiple Executor beans annotated with @%1$s found: %2$s. Please make sure a single instance is resolvable.", VaadinServiceEnabled.class.getSimpleName(), candidates);
            throw new IllegalStateException(message);
        }
        Instance managerFromResource = this.beanManager.createInstance().select(FromResource.class, new Annotation[0]);
        ManagedExecutorService resolvedManagedExecutor = null;
        if (managerFromResource.isResolvable()) {
            resolvedManagedExecutor = ((FromResource)managerFromResource.get()).managedExecutor;
        }
        if (resolvedManagedExecutor != null) {
            LoggerFactory.getLogger(VaadinTaskExecutorSelector.class).debug("Using container Managed Executor");
        }
        return Optional.ofNullable(resolvedManagedExecutor);
    }

    static class FromResource {
        @Resource
        ManagedExecutorService managedExecutor;

        FromResource() {
        }
    }
}

