/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.BeanLookup;
import com.vaadin.cdi.DeploymentValidator;
import com.vaadin.cdi.annotation.NormalRouteScoped;
import com.vaadin.cdi.annotation.NormalUIScoped;
import com.vaadin.cdi.annotation.VaadinServiceEnabled;
import com.vaadin.cdi.context.ContextWrapper;
import com.vaadin.cdi.context.RouteScopedContext;
import com.vaadin.cdi.context.UIScopedContext;
import com.vaadin.cdi.context.VaadinServiceScopedContext;
import com.vaadin.cdi.context.VaadinSessionScopedContext;
import com.vaadin.cdi.util.AbstractContext;
import com.vaadin.cdi.util.BeanProvider;
import com.vaadin.cdi.util.DependentProvider;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinExtension
implements Extension {
    private VaadinServiceScopedContext serviceScopedContext;
    private UIScopedContext uiScopedContext;
    private RouteScopedContext routeScopedContext;
    private Set<DeploymentValidator.BeanInfo> beanInfoSet = new HashSet<DeploymentValidator.BeanInfo>();

    private void storeBeanValidationInfo(@Observes ProcessBean processBean) {
        this.beanInfoSet.add(new DeploymentValidator.BeanInfo(processBean.getBean(), processBean.getAnnotated()));
    }

    private void addContexts(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.serviceScopedContext = new VaadinServiceScopedContext(beanManager);
        this.uiScopedContext = new UIScopedContext(beanManager);
        this.routeScopedContext = new RouteScopedContext(beanManager);
        this.addContext(afterBeanDiscovery, this.serviceScopedContext, null);
        this.addContext(afterBeanDiscovery, new VaadinSessionScopedContext(beanManager), null);
        this.addContext(afterBeanDiscovery, this.uiScopedContext, NormalUIScoped.class);
        this.addContext(afterBeanDiscovery, this.routeScopedContext, NormalRouteScoped.class);
    }

    private void initializeContexts(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        this.serviceScopedContext.init(beanManager);
        this.uiScopedContext.init(beanManager);
        this.routeScopedContext.init(beanManager, this.uiScopedContext::isActive);
    }

    private void validateDeployment(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        DependentProvider<DeploymentValidator> validatorProvider = BeanProvider.getDependent(beanManager, DeploymentValidator.class, new Annotation[0]);
        DeploymentValidator validator = validatorProvider.get();
        validator.validate(this.beanInfoSet, arg_0 -> ((AfterDeploymentValidation)adv).addDeploymentProblem(arg_0));
        validatorProvider.destroy();
        this.beanInfoSet = null;
    }

    private void ensureAtMostOneVaadinTaskExecutor(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        Set candidates = beanManager.getBeans(Executor.class, new Annotation[]{BeanLookup.SERVICE});
        if (candidates.size() > 1) {
            event.addDeploymentProblem((Throwable)new IllegalStateException("There must be at most one Executor bean annotated with @" + VaadinServiceEnabled.class.getSimpleName() + " in the application. Found " + candidates.size() + ": " + candidates));
        }
    }

    private void addContext(AfterBeanDiscovery afterBeanDiscovery, AbstractContext context, Class<? extends Annotation> additionalScope) {
        afterBeanDiscovery.addContext((Context)new ContextWrapper(context, context.getScope()));
        if (additionalScope != null) {
            afterBeanDiscovery.addContext((Context)new ContextWrapper(context, additionalScope));
        }
        VaadinExtension.getLogger().info("{} registered for Vaadin CDI", (Object)context.getClass().getSimpleName());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinExtension.class);
    }
}

