/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.BeanLookup;
import com.vaadin.cdi.CdiVaadinServlet;
import com.vaadin.cdi.annotation.VaadinServiceScoped;
import com.vaadin.cdi.context.VaadinSessionScopedContext;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.PollEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SystemMessagesProvider;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiVaadinServletService
extends VaadinServletService {
    private final CdiVaadinServiceDelegate delegate;

    public CdiVaadinServletService(CdiVaadinServlet servlet, DeploymentConfiguration configuration, BeanManager beanManager) {
        super((VaadinServlet)servlet, configuration);
        this.delegate = new CdiVaadinServiceDelegate(beanManager);
    }

    public void init() throws ServiceException {
        this.delegate.init((VaadinService)this);
        super.init();
    }

    public void fireUIInitListeners(UI ui) {
        this.delegate.addUIListeners(ui);
        super.fireUIInitListeners(ui);
    }

    protected VaadinSession loadSession(WrappedSession wrappedSession) {
        return super.loadSession(wrappedSession);
    }

    protected void storeSession(VaadinSession session, WrappedSession wrappedSession) {
        super.storeSession(session, wrappedSession);
    }

    private void restoreDelegate(VaadinSession session) {
    }

    public Optional<Instantiator> loadInstantiators() throws ServiceException {
        Bean bean;
        BeanManager beanManager = this.delegate.getBeanManager();
        Set beans = beanManager.getBeans(Instantiator.class, new Annotation[]{BeanLookup.SERVICE});
        if (beans == null || beans.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because no CDI instantiator bean found.");
        }
        try {
            bean = beanManager.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            throw new ServiceException("There are multiple eligible CDI " + Instantiator.class.getSimpleName() + " beans.", (Throwable)e);
        }
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Context context = beanManager.getContext(VaadinServiceScoped.class);
        Instantiator instantiator = (Instantiator)context.get((Contextual)bean, creationalContext);
        if (!instantiator.init((VaadinService)this)) {
            Class unproxiedClass = ProxyUtils.getUnproxiedClass(instantiator.getClass());
            throw new ServiceException("Cannot init VaadinService because " + unproxiedClass.getName() + " CDI bean init() returned false.");
        }
        return Optional.of(instantiator);
    }

    public CdiVaadinServlet getServlet() {
        return (CdiVaadinServlet)super.getServlet();
    }

    @ListenerPriority(value=-100)
    private static class UIEventListener
    implements AfterNavigationListener,
    BeforeEnterListener,
    BeforeLeaveListener,
    ComponentEventListener<PollEvent> {
        private final CdiVaadinServiceDelegate delegate;

        private UIEventListener(CdiVaadinServiceDelegate delegate) {
            this.delegate = delegate;
        }

        public void afterNavigation(AfterNavigationEvent event) {
            this.delegate.getBeanManager().fireEvent((Object)event, new Annotation[0]);
        }

        public void beforeEnter(BeforeEnterEvent event) {
            this.delegate.getBeanManager().fireEvent((Object)event, new Annotation[0]);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            this.delegate.getBeanManager().fireEvent((Object)event, new Annotation[0]);
        }

        public void onComponentEvent(PollEvent event) {
            this.delegate.getBeanManager().fireEvent((Object)event, new Annotation[0]);
        }
    }

    public static class CdiVaadinServiceDelegate
    implements Serializable {
        private transient BeanManager beanManager;
        private final UIEventListener uiEventListener;

        public CdiVaadinServiceDelegate(BeanManager beanManager) {
            this.beanManager = beanManager;
            this.uiEventListener = new UIEventListener(this);
        }

        public void init(VaadinService vaadinService) throws ServiceException {
            this.lookup(SystemMessagesProvider.class).ifPresent(arg_0 -> ((VaadinService)vaadinService).setSystemMessagesProvider(arg_0));
            vaadinService.addUIInitListener((UIInitListener & Serializable)e -> this.getBeanManager().fireEvent((Object)e, new Annotation[0]));
            vaadinService.addSessionInitListener(this::sessionInit);
            vaadinService.addSessionDestroyListener(this::sessionDestroy);
            vaadinService.addServiceDestroyListener(this::fireCdiDestroyEvent);
        }

        public void addUIListeners(UI ui) {
            ui.addAfterNavigationListener((AfterNavigationListener)this.uiEventListener);
            ui.addBeforeLeaveListener((BeforeLeaveListener)this.uiEventListener);
            ui.addBeforeEnterListener((BeforeEnterListener)this.uiEventListener);
            ui.addPollListener((ComponentEventListener)this.uiEventListener);
        }

        public <T> Optional<T> lookup(Class<T> type) throws ServiceException {
            try {
                T instance = new BeanLookup<T>(this.getBeanManager(), type, BeanLookup.SERVICE).lookup();
                return Optional.ofNullable(instance);
            }
            catch (AmbiguousResolutionException e) {
                throw new ServiceException("There are multiple eligible CDI " + type.getSimpleName() + " beans.", (Throwable)e);
            }
        }

        public BeanManager getBeanManager() {
            if (this.beanManager == null) {
                this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
            }
            return this.beanManager;
        }

        private void sessionInit(SessionInitEvent sessionInitEvent) throws ServiceException {
            VaadinSession session = sessionInitEvent.getSession();
            this.lookup(ErrorHandler.class).ifPresent(arg_0 -> ((VaadinSession)session).setErrorHandler(arg_0));
            this.getBeanManager().fireEvent((Object)sessionInitEvent, new Annotation[0]);
        }

        private void sessionDestroy(SessionDestroyEvent sessionDestroyEvent) {
            this.getBeanManager().fireEvent((Object)sessionDestroyEvent, new Annotation[0]);
            if (VaadinSessionScopedContext.guessContextIsUndeployed()) {
                CdiVaadinServiceDelegate.getLogger().warn("VaadinSessionScoped context does not exist. Maybe application is undeployed. Can't destroy VaadinSessionScopedContext.");
                return;
            }
            CdiVaadinServiceDelegate.getLogger().debug("VaadinSessionScopedContext destroy");
            VaadinSessionScopedContext.destroy(sessionDestroyEvent.getSession());
        }

        private void fireCdiDestroyEvent(ServiceDestroyEvent event) {
            try {
                this.getBeanManager().fireEvent((Object)event, new Annotation[0]);
            }
            catch (Exception e) {
                CdiVaadinServiceDelegate.getLogger().warn("Error at destroy event distribution with CDI.", (Throwable)e);
            }
        }

        private static Logger getLogger() {
            return LoggerFactory.getLogger(CdiVaadinServiceDelegate.class);
        }
    }
}

