/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.CdiVaadinServlet;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinServlet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class})
public class CdiServletDeployer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classSet, ServletContext ctx) {
        if (classSet == null) {
            return;
        }
        ServletRegistration rootServlet = CdiServletDeployer.findRootServlet(ctx);
        if (rootServlet != null) {
            return;
        }
        ServletRegistration vaadinServlet = CdiServletDeployer.findVaadinServlet(ctx);
        if (vaadinServlet != null) {
            return;
        }
        String servletName = this.getClass().getName();
        ServletRegistration.Dynamic registration = ctx.addServlet(servletName, CdiVaadinServlet.class);
        if (registration == null) {
            return;
        }
        CdiServletDeployer.getLogger().info("Automatically deploying CDI Vaadin servlet to /*");
        registration.setAsyncSupported(true);
        registration.addMapping(new String[]{"/*"});
        registration.setLoadOnStartup(1);
    }

    private static ServletRegistration findRootServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> registration.getMappings().contains("/*")).findAny().orElse(null);
    }

    private static ServletRegistration findVaadinServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> CdiServletDeployer.isVaadinServlet(context.getClassLoader(), registration)).findAny().orElse(null);
    }

    private static boolean isVaadinServlet(ClassLoader classLoader, ServletRegistration registration) {
        String className = registration.getClassName();
        try {
            return VaadinServlet.class.isAssignableFrom(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            CdiServletDeployer.getLogger().info("Assuming {} is not a Vaadin servlet", (Object)className, (Object)e);
            return false;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CdiServletDeployer.class);
    }
}

