/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.card;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.card.CardVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Tag(value="vaadin-card")
@NpmPackage(value="@vaadin/card", version="25.1.0-alpha7")
@JsModule(value="@vaadin/card/src/vaadin-card.js")
public class Card
extends Component
implements HasSize,
HasThemeVariant<CardVariant>,
HasComponents,
HasAriaLabel {
    private static final String MEDIA_SLOT_NAME = "media";
    private static final String TITLE_SLOT_NAME = "title";
    private static final String SUBTITLE_SLOT_NAME = "subtitle";
    private static final String HEADER_SLOT_NAME = "header";
    private static final String HEADER_PREFIX_SLOT_NAME = "header-prefix";
    private static final String HEADER_SUFFIX_SLOT_NAME = "header-suffix";
    private static final String FOOTER_SLOT_NAME = "footer";
    private static final String CARD_TITLE_PROPERTY = "cardTitle";
    private static final String TITLE_HEADING_LEVEL_PROPERTY = "titleHeadingLevel";

    public void setMedia(Component media) {
        SlotUtils.setSlot((HasElement)this, (String)MEDIA_SLOT_NAME, (Component[])new Component[]{media});
    }

    public Component getMedia() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)MEDIA_SLOT_NAME);
    }

    public void setTitle(String title) {
        this.doSetTitle((Component)null);
        this.doSetTitle(title);
    }

    public void setTitle(String title, Integer titleHeadingLevel) {
        this.setTitleHeadingLevel(titleHeadingLevel);
        this.setTitle(title);
    }

    public void setTitleHeadingLevel(Integer titleHeadingLevel) {
        if (titleHeadingLevel == null) {
            this.getElement().removeProperty(TITLE_HEADING_LEVEL_PROPERTY);
        } else {
            this.getElement().setProperty(TITLE_HEADING_LEVEL_PROPERTY, (double)titleHeadingLevel.intValue());
        }
    }

    public void setTitle(Component title) {
        this.doSetTitle((String)null);
        this.doSetTitle(title);
    }

    public String getTitleAsText() {
        return this.getElement().getProperty(CARD_TITLE_PROPERTY, "");
    }

    public Component getTitle() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)TITLE_SLOT_NAME);
    }

    public void setSubtitle(Component subtitle) {
        SlotUtils.setSlot((HasElement)this, (String)SUBTITLE_SLOT_NAME, (Component[])new Component[]{subtitle});
    }

    public void setSubtitle(String subtitle) {
        if (subtitle == null) {
            this.setSubtitle((Component)null);
        } else {
            this.setSubtitle((Component)new Span(subtitle));
        }
    }

    public Component getSubtitle() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)SUBTITLE_SLOT_NAME);
    }

    public void setHeader(Component header) {
        SlotUtils.setSlot((HasElement)this, (String)HEADER_SLOT_NAME, (Component[])new Component[]{header});
    }

    public Component getHeader() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)HEADER_SLOT_NAME);
    }

    public void setHeaderPrefix(Component headerPrefix) {
        SlotUtils.setSlot((HasElement)this, (String)HEADER_PREFIX_SLOT_NAME, (Component[])new Component[]{headerPrefix});
    }

    public Component getHeaderPrefix() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)HEADER_PREFIX_SLOT_NAME);
    }

    public void setHeaderSuffix(Component headerSuffix) {
        SlotUtils.setSlot((HasElement)this, (String)HEADER_SUFFIX_SLOT_NAME, (Component[])new Component[]{headerSuffix});
    }

    public Component getHeaderSuffix() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)HEADER_SUFFIX_SLOT_NAME);
    }

    public void addToFooter(Component ... footerComponent) {
        Objects.requireNonNull(footerComponent, "Components should not be null");
        List<Component> componentsToAdd = Arrays.stream(footerComponent).map(component -> Objects.requireNonNull(component, "Component to add cannot be null")).toList();
        componentsToAdd.forEach(component -> SlotUtils.addToSlot((HasElement)this, (String)FOOTER_SLOT_NAME, (Component[])new Component[]{component}));
    }

    public Component[] getFooterComponents() {
        return (Component[])SlotUtils.getElementsInSlot((HasElement)this, (String)FOOTER_SLOT_NAME).map(Element::getComponent).map(Optional::orElseThrow).toArray(Component[]::new);
    }

    public Stream<Component> getChildren() {
        return super.getChildren().filter(child -> !child.getElement().hasAttribute("slot"));
    }

    public void removeAll() {
        this.getChildren().toList().forEach(xva$0 -> this.remove(new Component[]{xva$0}));
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        List<Component> children = this.getChildren().toList();
        if (index > children.size()) {
            throw new IllegalArgumentException("The 'index' argument is out of bounds. The specified index (" + index + ") is greater than the current number of child components in the default slot (" + children.size() + ").");
        }
        if (index == children.size()) {
            this.getElement().appendChild(new Element[]{component.getElement()});
        } else {
            Component reference = children.get(index);
            int actualIndex = this.getElement().indexOfChild(reference.getElement());
            this.getElement().insertChild(actualIndex, new Element[]{component.getElement()});
        }
    }

    public void setAriaRole(String role) {
        if (role == null) {
            this.getElement().removeAttribute("role");
        } else {
            this.getElement().setAttribute("role", role);
        }
    }

    public Optional<String> getAriaRole() {
        return Optional.ofNullable(this.getElement().getAttribute("role"));
    }

    private void doSetTitle(String title) {
        if (title == null) {
            this.getElement().removeProperty(CARD_TITLE_PROPERTY);
        } else {
            this.getElement().setProperty(CARD_TITLE_PROPERTY, title);
        }
    }

    private void doSetTitle(Component title) {
        SlotUtils.setSlot((HasElement)this, (String)TITLE_SLOT_NAME, (Component[])new Component[]{title});
    }
}

