/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.button;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.SignalPropertySupport;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.internal.DisableOnClickController;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;

@Tag(value="vaadin-button")
@NpmPackage(value="@vaadin/button", version="25.1.0-alpha6")
@JsModule(value="@vaadin/button/src/vaadin-button.js")
public class Button
extends Component
implements ClickNotifier<Button>,
Focusable<Button>,
HasAriaLabel,
HasEnabled,
HasPrefix,
HasSize,
HasStyle,
HasSuffix,
HasText,
HasThemeVariant<ButtonVariant>,
HasTooltip {
    private Component iconComponent;
    private boolean iconAfterText;
    private final DisableOnClickController<Button> disableOnClickController = new DisableOnClickController((Component)this);
    private final Text textNode = new Text("");
    private final SignalPropertySupport<String> textSupport = SignalPropertySupport.create((Component)this, this::textChangeHandler);

    public Button() {
        this.add(new Component[]{this.textNode});
    }

    public Button(String text) {
        this();
        this.setText(text);
    }

    public Button(Signal<String> textSignal) {
        this();
        this.bindText(textSignal);
    }

    public Button(Component icon) {
        this();
        this.setIcon(icon);
    }

    public Button(String text, Component icon) {
        this();
        this.setIcon(icon);
        this.setText(text);
    }

    public Button(Signal<String> textSignal, Component icon) {
        this();
        this.setIcon(icon);
        this.bindText(textSignal);
    }

    public Button(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this();
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public Button(Signal<String> textSignal, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this();
        this.bindText(textSignal);
        this.addClickListener(clickListener);
    }

    public Button(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this();
        this.setIcon(icon);
        this.addClickListener(clickListener);
    }

    public Button(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this();
        this.setIcon(icon);
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public Button(Signal<String> textSignal, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this();
        this.setIcon(icon);
        this.bindText(textSignal);
        this.addClickListener(clickListener);
    }

    public void setText(String text) {
        this.textNode.setText(text);
        this.textChangeHandler(text);
    }

    public String getText() {
        return this.textNode.getText();
    }

    public void bindText(Signal<String> textSignal) {
        this.textNode.bindText(textSignal);
        this.textSupport.bind(textSignal);
    }

    public void setIcon(Component icon) {
        if (icon != null && icon.getElement().isTextNode()) {
            throw new IllegalArgumentException("Text node can't be used as an icon.");
        }
        if (this.iconComponent != null) {
            this.remove(this.iconComponent);
        }
        this.iconComponent = icon;
        if (icon != null) {
            this.add(icon);
            this.updateIconSlot();
        }
        this.updateThemeAttribute();
    }

    public Component getIcon() {
        return this.iconComponent;
    }

    public void setIconAfterText(boolean iconAfterText) {
        this.iconAfterText = iconAfterText;
        this.updateIconSlot();
    }

    public boolean isIconAfterText() {
        return this.iconAfterText;
    }

    public void click() {
        if (this.isEnabled()) {
            this.fireEvent((ComponentEvent)new ClickEvent((Component)this, false, 0, 0, 0, 0, 0, 0, false, false, false, false));
        }
    }

    public void clickInClient() {
        this.getElement().callJsFunction("click", new Object[0]);
    }

    private void add(Component ... components) {
        assert (components != null);
        for (Component component : components) {
            assert (component != null);
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setDisableOnClick(boolean disableOnClick) {
        this.disableOnClickController.setDisableOnClick(disableOnClick);
    }

    public boolean isDisableOnClick() {
        return this.disableOnClickController.isDisableOnClick();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.disableOnClickController.onSetEnabled(enabled);
    }

    public ShortcutRegistration addFocusShortcut(Key key, KeyModifier ... keyModifiers) {
        ShortcutRegistration registration = super.addFocusShortcut(key, keyModifiers);
        if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
            registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        }
        return registration;
    }

    public Registration addFocusListener(ComponentEventListener<FocusNotifier.FocusEvent<Button>> listener) {
        return this.getEventBus().addListener(FocusNotifier.FocusEvent.class, listener, registration -> {
            if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
                registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
            }
        });
    }

    public Registration addBlurListener(ComponentEventListener<BlurNotifier.BlurEvent<Button>> listener) {
        return this.getEventBus().addListener(BlurNotifier.BlurEvent.class, listener, registration -> {
            if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
                registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
            }
        });
    }

    private void updateIconSlot() {
        if (this.iconComponent == null) {
            return;
        }
        if (this.hasIconOnly()) {
            this.iconComponent.getElement().removeAttribute("slot");
        } else {
            this.iconComponent.getElement().setAttribute("slot", this.iconAfterText ? "suffix" : "prefix");
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + String.valueOf(component) + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    private void updateThemeAttribute() {
        if (this.hasIconOnly()) {
            this.getThemeNames().add((Object)"icon");
        } else {
            this.getThemeNames().remove((Object)"icon");
        }
    }

    private boolean isFeatureFlagEnabled(Feature feature) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            return false;
        }
        return FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext()).isEnabled(feature);
    }

    private boolean hasIconOnly() {
        long childCount = this.getElement().getChildren().filter(el -> el.isTextNode() ? !el.getText().isEmpty() : !"vaadin-tooltip".equals(el.getTag())).count();
        return childCount == 1L && this.iconComponent != null;
    }

    private void updateChildren() {
        Element[] elements = (Element[])this.getElement().getChildren().toArray(Element[]::new);
        this.getElement().removeAllChildren();
        this.getElement().appendChild(elements);
    }

    private void textChangeHandler(String text) {
        this.updateChildren();
        this.updateIconSlot();
        this.updateThemeAttribute();
    }
}

