/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.badge;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.SignalPropertySupport;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.badge.BadgeFeatureFlagProvider;
import com.vaadin.flow.component.badge.BadgeVariant;
import com.vaadin.flow.component.badge.ExperimentalFeatureException;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.signals.Signal;
import java.util.Optional;

@Tag(value="vaadin-badge")
@NpmPackage(value="@vaadin/badge", version="25.1.0-beta1")
@JsModule(value="@vaadin/badge/src/vaadin-badge.js")
public class Badge
extends Component
implements HasSize,
HasText,
HasThemeVariant<BadgeVariant> {
    private static final String ICON_SLOT = "icon";
    private final Text textNode = new Text("");
    private final SignalPropertySupport<String> textSignalSupport = SignalPropertySupport.create((Component)this, this::updateText);

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.checkFeatureFlag(attachEvent.getUI());
    }

    private void checkFeatureFlag(UI ui) {
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
        boolean enabled = featureFlags.isEnabled(BadgeFeatureFlagProvider.BADGE_COMPONENT);
        if (!enabled) {
            throw new ExperimentalFeatureException();
        }
    }

    public Badge() {
    }

    public Badge(String text) {
        this.setText(text);
    }

    public Badge(Component icon) {
        this.setIcon(icon);
    }

    public Badge(String text, Component icon) {
        this.setText(text);
        this.setIcon(icon);
    }

    public Badge(String text, int number) {
        this.setText(text);
        this.setNumber(number);
    }

    public Badge(String text, int number, Component icon) {
        this.setText(text);
        this.setNumber(number);
        this.setIcon(icon);
    }

    public Badge(Signal<String> textSignal) {
        this();
        this.bindText(textSignal);
    }

    public Badge(Signal<String> textSignal, Component icon) {
        this();
        this.setIcon(icon);
        this.bindText(textSignal);
    }

    public void setText(String text) {
        this.textSignalSupport.set((Object)text);
    }

    public String getText() {
        return (String)this.textSignalSupport.get();
    }

    public void bindText(Signal<String> textSignal) {
        this.textSignalSupport.bind(textSignal);
    }

    public void setNumber(Integer number) {
        if (number == null) {
            this.getElement().removeProperty("number");
        } else {
            this.getElement().setProperty("number", (double)number.intValue());
        }
    }

    public void bindNumber(Signal<Integer> numberSignal) {
        this.getElement().bindProperty("number", numberSignal, null);
    }

    public Integer getNumber() {
        return Optional.ofNullable(this.getElement().getProperty("number")).map(Integer::valueOf).orElse(null);
    }

    public void setContent(Component content) {
        Component oldContent = this.getContent();
        if (oldContent == content) {
            return;
        }
        if (oldContent != null) {
            this.getElement().removeChild(new Element[]{oldContent.getElement()});
        }
        if (content != null) {
            this.getElement().appendChild(new Element[]{content.getElement()});
        }
    }

    public Component getContent() {
        return this.getChildren().filter(component -> !component.equals(this.textNode) && !component.getElement().hasAttribute("slot")).findAny().orElse(null);
    }

    public void setIcon(Component icon) {
        if (icon == null) {
            SlotUtils.clearSlot((HasElement)this, (String)ICON_SLOT);
        } else {
            SlotUtils.setSlot((HasElement)this, (String)ICON_SLOT, (Component[])new Component[]{icon});
        }
    }

    public Component getIcon() {
        return SlotUtils.getChildInSlot((HasElement)this, (String)ICON_SLOT);
    }

    public void setRole(String role) {
        if (role == null) {
            this.getElement().removeAttribute("role");
        } else {
            this.getElement().setAttribute("role", role);
        }
    }

    public String getRole() {
        return this.getElement().getAttribute("role");
    }

    private void updateText(String text) {
        this.textNode.setText(text);
        if (text == null || text.isEmpty()) {
            this.getElement().removeChild(new Element[]{this.textNode.getElement()});
            return;
        }
        if (this.textNode.getParent().isEmpty()) {
            this.getElement().appendChild(new Element[]{this.textNode.getElement()});
        }
    }
}

