/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.avatar;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.avatar.AvatarVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-avatar")
@JsModule(value="@vaadin/avatar/src/vaadin-avatar.js")
@NpmPackage(value="@vaadin/avatar", version="25.0.0-alpha17")
public class Avatar
extends Component
implements HasStyle,
HasSize,
HasThemeVariant<AvatarVariant> {
    private AbstractStreamResource imageResource;
    private AvatarI18n i18n;

    public Avatar() {
    }

    public Avatar(String name) {
        this.setName(name);
    }

    public Avatar(String name, String url) {
        this.setName(name);
        this.setImage(url);
    }

    public AvatarI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(AvatarI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        ObjectNode i18nObject = JacksonUtils.beanToJson((Object)i18n);
        this.getElement().setPropertyJson("i18n", (BaseJsonNode)i18nObject);
    }

    public String getName() {
        return this.getElement().getProperty("name");
    }

    public void setName(String name) {
        this.getElement().setProperty("name", name);
    }

    public String getAbbreviation() {
        return this.getElement().getProperty("abbr");
    }

    public void setAbbreviation(String abbr) {
        this.getElement().setProperty("abbr", abbr);
    }

    public String getImage() {
        return this.getElement().getAttribute("img");
    }

    public AbstractStreamResource getImageResource() {
        return this.imageResource;
    }

    public void setImage(String url) {
        this.imageResource = null;
        if (url == null) {
            this.getElement().removeAttribute("img");
        } else {
            this.getElement().setAttribute("img", url);
        }
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setImageResource(AbstractStreamResource resource) {
        this.imageResource = resource;
        if (resource == null) {
            this.getElement().removeAttribute("img");
            return;
        }
        this.getElement().setAttribute("img", resource);
    }

    public void setImageHandler(DownloadHandler downloadHandler) {
        if (downloadHandler == null) {
            this.imageResource = null;
            this.getElement().removeAttribute("img");
            return;
        }
        if (downloadHandler instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler handler = (AbstractDownloadHandler)downloadHandler;
            handler.inline();
        }
        this.imageResource = new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)downloadHandler, this.getElement());
        this.getElement().setAttribute("img", this.imageResource);
    }

    public Integer getColorIndex() {
        String colorIndex = this.getElement().getProperty("colorIndex");
        if (colorIndex != null && !colorIndex.isEmpty()) {
            return Integer.parseInt(colorIndex);
        }
        return null;
    }

    public void setColorIndex(Integer colorIndex) {
        this.getElement().setProperty("colorIndex", (double)colorIndex.intValue());
    }

    public boolean isTooltipEnabled() {
        return this.getElement().getProperty("withTooltip", false);
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.getElement().setProperty("withTooltip", tooltipEnabled);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AvatarI18n
    implements Serializable {
        private String anonymous;

        public String getAnonymous() {
            return this.anonymous;
        }

        public AvatarI18n setAnonymous(String anonymous) {
            Objects.requireNonNull(anonymous, "The translation should not be null");
            this.anonymous = anonymous;
            return this;
        }
    }
}

