/*
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.theme.aura;

import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;

/**
 * Aura theme base class.
 */
@NpmPackage(value = "@vaadin/aura", version = "25.1.0-alpha6")
public class Aura {
    /**
     * The path to the Aura stylesheet. Can be used as argument to a
     * {@link StyleSheet} on an {@link AppShellConfigurator} class to apply the
     * Aura theme to an application.
     */
    public static final String STYLESHEET = "aura/aura.css";
}
