/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.router.RouterLayout;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import tools.jackson.databind.node.BaseJsonNode;

@Tag(value="vaadin-app-layout")
@NpmPackage(value="@vaadin/app-layout", version="25.1.0-alpha6")
@JsModule(value="@vaadin/app-layout/src/vaadin-app-layout.js")
public class AppLayout
extends Component
implements RouterLayout,
HasStyle {
    private static final PropertyDescriptor<String, String> primarySectionProperty = PropertyDescriptors.propertyWithDefault((String)"primarySection", (String)Section.NAVBAR.toWebcomponentValue());
    private static final PropertyDescriptor<Boolean, Boolean> overlayProperty = PropertyDescriptors.propertyWithDefault((String)"overlay", (Boolean)false);
    private Component content;
    private AppLayoutI18n i18n;

    public AppLayoutI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(AppLayoutI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.getElement().setPropertyJson("i18n", (BaseJsonNode)JacksonUtils.beanToJson((Object)i18n));
    }

    @Synchronize(value={"primary-section-changed"})
    public Section getPrimarySection() {
        return Section.fromWebcomponentValue((String)primarySectionProperty.get((HasElement)this));
    }

    public void setPrimarySection(Section primarySection) {
        Objects.requireNonNull(primarySection, "primary section must not be null");
        primarySectionProperty.set((HasElement)this, (Object)primarySection.toWebcomponentValue());
    }

    @Synchronize(value={"drawer-opened-changed"})
    public boolean isDrawerOpened() {
        return this.getElement().getProperty("drawerOpened", true);
    }

    public void setDrawerOpened(boolean drawerOpened) {
        this.getElement().setProperty("drawerOpened", drawerOpened);
    }

    @Synchronize(value={"overlay-changed"})
    public boolean isOverlay() {
        return (Boolean)overlayProperty.get((HasElement)this);
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.removeContent();
        if (content != null) {
            this.content = content;
            content.getElement().removeAttribute("slot");
            this.add(content);
        }
    }

    public void addToDrawer(Component ... components) {
        SlotUtils.addToSlot((HasElement)this, (String)"drawer", (Component[])components);
    }

    public void addToNavbar(Component ... components) {
        boolean touchOptimized = false;
        this.addToNavbar(false, components);
    }

    public void addToNavbar(boolean touchOptimized, Component ... components) {
        String slot = "navbar" + (touchOptimized ? " touch-optimized" : "");
        SlotUtils.addToSlot((HasElement)this, (String)slot, (Component[])components);
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            if (this.content != null && this.content.equals(component)) {
                this.content = null;
            }
            this.remove(component);
        }
    }

    public void showRouterLayoutContent(HasElement content) {
        Component target = null;
        if (content != null) {
            target = (Component)content.getElement().getComponent().orElseThrow(() -> new IllegalArgumentException("AppLayout content must be a Component"));
        }
        this.setContent(target);
        this.afterNavigation();
    }

    void afterNavigation() {
        if (this.isOverlay()) {
            this.setDrawerOpened(false);
        }
    }

    private void add(Component component) {
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    private void removeContent() {
        this.remove(this.content);
        this.content = null;
    }

    private void remove(Component component) {
        if (component != null) {
            component.getElement().removeFromParent();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AppLayoutI18n
    implements Serializable {
        private String drawer;

        public String getDrawer() {
            return this.drawer;
        }

        public AppLayoutI18n setDrawer(String drawer) {
            this.drawer = drawer;
            return this;
        }
    }

    public static enum Section {
        NAVBAR,
        DRAWER;


        public String toWebcomponentValue() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Section fromWebcomponentValue(String webcomponentValue) {
            return webcomponentValue != null ? Section.valueOf(webcomponentValue.toUpperCase()) : null;
        }
    }
}

