/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.orchestrator;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.ai.AIComponentsExperimentalFeatureException;
import com.vaadin.flow.component.ai.common.AIAttachment;
import com.vaadin.flow.component.ai.orchestrator.AttachmentClickListener;
import com.vaadin.flow.component.ai.orchestrator.AttachmentSubmitListener;
import com.vaadin.flow.component.ai.orchestrator.MessageInputWrapper;
import com.vaadin.flow.component.ai.orchestrator.MessageListWrapper;
import com.vaadin.flow.component.ai.orchestrator.UploadManagerWrapper;
import com.vaadin.flow.component.ai.provider.LLMProvider;
import com.vaadin.flow.component.ai.ui.AIFileReceiver;
import com.vaadin.flow.component.ai.ui.AIInput;
import com.vaadin.flow.component.ai.ui.AIMessage;
import com.vaadin.flow.component.ai.ui.AIMessageList;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.upload.UploadHelper;
import com.vaadin.flow.component.upload.UploadManager;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinContext;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AIOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AIOrchestrator.class);
    private static final int TIMEOUT_SECONDS = 600;
    static final String FEATURE_FLAG_ID = "aiComponents";
    private final LLMProvider provider;
    private final String systemPrompt;
    private AIMessageList messageList;
    private AIInput input;
    private AIFileReceiver fileReceiver;
    private Object[] tools = new Object[0];
    private String userName;
    private String assistantName;
    private AttachmentSubmitListener attachmentSubmitListener;
    private AttachmentClickListener attachmentClickListener;
    private final Map<AIMessage, String> itemToMessageId = new HashMap<AIMessage, String>();
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);
    private final AtomicBoolean featureFlagChecked = new AtomicBoolean(false);

    private AIOrchestrator(LLMProvider provider, String systemPrompt) {
        Objects.requireNonNull(provider, "Provider cannot be null");
        this.provider = provider;
        this.systemPrompt = systemPrompt;
    }

    public static Builder builder(LLMProvider provider, String systemPrompt) {
        return new Builder(provider, systemPrompt);
    }

    public void prompt(String userMessage) {
        this.doPrompt(userMessage);
    }

    private AIMessage addUserMessageToList(String userMessage, List<AIAttachment> attachments) {
        if (this.messageList != null) {
            return this.messageList.addMessage(userMessage, this.userName, attachments);
        }
        return null;
    }

    private AIMessage createAssistantMessagePlaceholder() {
        if (this.messageList == null) {
            return null;
        }
        return this.messageList.addMessage("", this.assistantName, Collections.emptyList());
    }

    private void streamResponseToMessage(LLMProvider.LLMRequest request, AIMessage assistantMessage, UI ui) {
        Flux responseStream = this.provider.stream(request).timeout(Duration.ofSeconds(600L));
        responseStream.doFinally(signal -> this.isProcessing.set(false)).subscribe(token -> {
            if (assistantMessage != null && this.messageList != null) {
                ui.access((Command & Serializable)() -> assistantMessage.appendText((String)token));
            }
        }, error -> {
            String userMessage;
            if (error instanceof TimeoutException) {
                userMessage = "Request timed out. Please try again.";
                LOGGER.warn("LLM request timed out after {} seconds", (Object)600);
            } else {
                userMessage = "An error occurred. Please try again.";
                LOGGER.error("Error during LLM streaming", error);
            }
            if (assistantMessage != null && this.messageList != null) {
                ui.access((Command & Serializable)() -> assistantMessage.setText(userMessage));
            }
        }, () -> LOGGER.debug("LLM streaming completed successfully"));
    }

    private void doPrompt(String userMessage) {
        if (userMessage == null || userMessage.isBlank()) {
            return;
        }
        if (!this.isProcessing.compareAndSet(false, true)) {
            LOGGER.warn("Ignoring prompt: another request is already in progress");
            return;
        }
        this.processUserInput(userMessage);
    }

    private void processUserInput(final String userMessage) {
        UI ui = UI.getCurrentOrThrow();
        this.checkFeatureFlag(ui);
        final List<AIAttachment> attachments = this.fileReceiver != null ? this.fileReceiver.takeAttachments() : List.of();
        AIMessage userAIMessage = this.addUserMessageToList(userMessage, attachments);
        String messageId = UUID.randomUUID().toString();
        if (userAIMessage != null) {
            this.itemToMessageId.put(userAIMessage, messageId);
        }
        if (!attachments.isEmpty() && this.attachmentSubmitListener != null) {
            List<AIAttachment> attachmentsCopy = List.copyOf(attachments);
            this.attachmentSubmitListener.onAttachmentSubmit(new AttachmentSubmitListener.AttachmentSubmitEvent(messageId, attachmentsCopy));
        }
        AIMessage assistantMessage = this.createAssistantMessagePlaceholder();
        String effectiveSystemPrompt = null;
        if (this.systemPrompt != null && !this.systemPrompt.isBlank()) {
            effectiveSystemPrompt = this.systemPrompt.trim();
        }
        final String finalSystemPrompt = effectiveSystemPrompt;
        LLMProvider.LLMRequest request = new LLMProvider.LLMRequest(){

            @Override
            public String userMessage() {
                return userMessage;
            }

            @Override
            public List<AIAttachment> attachments() {
                return attachments;
            }

            @Override
            public String systemPrompt() {
                return finalSystemPrompt;
            }

            @Override
            public Object[] tools() {
                return AIOrchestrator.this.tools;
            }
        };
        LOGGER.debug("Processing prompt with {} attachments", (Object)attachments.size());
        this.streamResponseToMessage(request, assistantMessage, ui);
    }

    private void checkFeatureFlag(UI ui) {
        if (this.featureFlagChecked.get()) {
            return;
        }
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
        if (!featureFlags.isEnabled(FEATURE_FLAG_ID)) {
            throw new AIComponentsExperimentalFeatureException("AIOrchestrator");
        }
        this.featureFlagChecked.set(true);
    }

    public static class Builder {
        private final LLMProvider provider;
        private final String systemPrompt;
        private AIMessageList messageList;
        private AIInput input;
        private AIFileReceiver fileReceiver;
        private Object[] tools = new Object[0];
        private String userName;
        private String assistantName;
        private AttachmentSubmitListener attachmentSubmitListener;
        private AttachmentClickListener attachmentClickListener;

        private Builder(LLMProvider provider, String systemPrompt) {
            Objects.requireNonNull(provider, "Provider cannot be null");
            this.provider = provider;
            this.systemPrompt = systemPrompt;
        }

        public Builder withMessageList(AIMessageList messageList) {
            this.messageList = messageList;
            return this;
        }

        public Builder withMessageList(MessageList messageList) {
            this.messageList = Builder.wrapMessageList(messageList);
            return this;
        }

        public Builder withInput(AIInput input) {
            this.input = input;
            return this;
        }

        public Builder withInput(MessageInput messageInput) {
            this.input = Builder.wrapInput(messageInput);
            return this;
        }

        public Builder withFileReceiver(AIFileReceiver fileReceiver) {
            this.fileReceiver = fileReceiver;
            return this;
        }

        public Builder withFileReceiver(UploadManager uploadManager) {
            if (uploadManager != null && UploadHelper.hasUploadHandler((UploadManager)uploadManager)) {
                throw new IllegalArgumentException("The provided UploadManager already has an UploadHandler.");
            }
            this.fileReceiver = Builder.wrapUploadManager(uploadManager);
            return this;
        }

        public Builder withTools(Object ... tools) {
            this.tools = tools != null ? tools : new Object[]{};
            return this;
        }

        public Builder withUserName(String userName) {
            Objects.requireNonNull(userName, "User name cannot be null");
            this.userName = userName;
            return this;
        }

        public Builder withAssistantName(String assistantName) {
            Objects.requireNonNull(assistantName, "Assistant name cannot be null");
            this.assistantName = assistantName;
            return this;
        }

        public Builder withAttachmentSubmitListener(AttachmentSubmitListener listener) {
            this.attachmentSubmitListener = listener;
            return this;
        }

        public Builder withAttachmentClickListener(AttachmentClickListener listener) {
            this.attachmentClickListener = listener;
            return this;
        }

        public AIOrchestrator build() {
            AIOrchestrator orchestrator = new AIOrchestrator(this.provider, this.systemPrompt);
            orchestrator.messageList = this.messageList;
            orchestrator.input = this.input;
            orchestrator.fileReceiver = this.fileReceiver;
            orchestrator.tools = this.tools == null ? new Object[]{} : this.tools;
            orchestrator.userName = this.userName == null ? "You" : this.userName;
            orchestrator.assistantName = this.assistantName == null ? "Assistant" : this.assistantName;
            orchestrator.attachmentSubmitListener = this.attachmentSubmitListener;
            orchestrator.attachmentClickListener = this.attachmentClickListener;
            if (this.input != null) {
                this.input.addSubmitListener((SerializableConsumer<String>)((SerializableConsumer & Serializable)orchestrator::doPrompt));
            }
            if (this.attachmentClickListener != null && this.messageList != null) {
                this.messageList.addAttachmentClickListener((message, attIndex) -> {
                    String messageId = orchestrator.itemToMessageId.get(message);
                    if (messageId != null) {
                        orchestrator.attachmentClickListener.onAttachmentClick(new AttachmentClickListener.AttachmentClickEvent(messageId, attIndex));
                    }
                });
            }
            LOGGER.debug("Built AIOrchestrator with messageList={}, input={}, fileReceiver={}, tools={}, userName={}, assistantName={}", new Object[]{orchestrator.messageList != null, orchestrator.input != null, orchestrator.fileReceiver != null, orchestrator.tools.length, orchestrator.userName, orchestrator.assistantName});
            return orchestrator;
        }

        private static AIMessageList wrapMessageList(MessageList messageList) {
            return new MessageListWrapper(messageList);
        }

        private static AIInput wrapInput(MessageInput messageInput) {
            return new MessageInputWrapper(messageInput);
        }

        private static AIFileReceiver wrapUploadManager(UploadManager uploadManager) {
            return new UploadManagerWrapper(uploadManager);
        }
    }
}

