/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.provider;

import com.vaadin.flow.component.ai.common.AiAttachment;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

final class LLMProviderHelpers {
    LLMProviderHelpers() {
    }

    public static String decodeAsUtf8(byte[] data, String fileName, boolean strict) {
        if (!strict) {
            return new String(data, StandardCharsets.UTF_8);
        }
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            return decoder.decode(ByteBuffer.wrap(data)).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("File '" + fileName + "' contains invalid UTF-8 data.", e);
        }
    }

    public static String getBase64Data(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static String formatTextAttachment(String fileName, String content) {
        return "\n<attachment filename=\"" + fileName + "\">\n" + content + "\n</attachment>\n";
    }

    public static void validateAttachment(AiAttachment attachment) {
        Objects.requireNonNull(attachment, "Attachment must not be null");
        Objects.requireNonNull(attachment.mimeType(), "Attachment content type must not be null");
        Objects.requireNonNull(attachment.data(), "Attachment data must not be null");
    }
}

