/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.provider;

import com.vaadin.flow.component.ai.provider.AttachmentContentType;
import com.vaadin.flow.component.ai.provider.LLMProvider;
import com.vaadin.flow.component.ai.provider.LLMProviderHelpers;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.memory.MessageWindowChatMemory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.content.Media;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public class SpringAiLLMProvider
implements LLMProvider {
    private static final int MAX_MESSAGES = 30;
    private static final String CONVERSATION_ID = "default";
    private final transient ChatClient chatClient;
    private boolean isStreaming = true;

    public SpringAiLLMProvider(ChatModel chatModel) {
        Objects.requireNonNull(chatModel, "ChatModel must not be null");
        MessageWindowChatMemory chatMemory = MessageWindowChatMemory.builder().maxMessages(30).build();
        this.chatClient = ChatClient.builder((ChatModel)chatModel).defaultAdvisors(new Advisor[]{MessageChatMemoryAdvisor.builder((ChatMemory)chatMemory).conversationId(CONVERSATION_ID).build()}).build();
    }

    public SpringAiLLMProvider(ChatClient chatClient) {
        Objects.requireNonNull(chatClient, "ChatClient must not be null");
        this.chatClient = chatClient;
    }

    @Override
    public Flux<String> stream(LLMProvider.LLMRequest request) {
        Objects.requireNonNull(request, "Request must not be null");
        Objects.requireNonNull(request.userMessage(), "User message must not be null");
        if (this.isStreaming) {
            return this.executeStreamingChat(request);
        }
        return this.executeNonStreamingChat(request);
    }

    public void setStreaming(boolean streaming) {
        this.isStreaming = streaming;
    }

    private Flux<String> executeStreamingChat(LLMProvider.LLMRequest request) {
        try {
            return this.getPromptSpec(request).stream().content();
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private ChatClient.ChatClientRequestSpec getPromptSpec(LLMProvider.LLMRequest request) {
        Object[] tools;
        ChatClient.ChatClientRequestSpec promptSpec = this.chatClient.prompt();
        promptSpec = promptSpec.user(userSpec -> {
            userSpec.text(request.userMessage());
            Media[] media = this.buildMedia(request);
            if (media.length != 0) {
                userSpec.media(media);
            }
        });
        if (request.systemPrompt() != null && !request.systemPrompt().trim().isEmpty()) {
            promptSpec = promptSpec.system(request.systemPrompt().trim());
        }
        if ((tools = request.tools()) != null && tools.length > 0) {
            promptSpec = promptSpec.tools(tools);
        }
        return promptSpec;
    }

    private Flux<String> executeNonStreamingChat(LLMProvider.LLMRequest request) {
        return Flux.create(sink -> {
            try {
                ChatClient.ChatClientRequestSpec promptSpec = this.getPromptSpec(request);
                String response = promptSpec.call().content();
                if (response != null && !response.isEmpty()) {
                    sink.next((Object)response);
                }
                sink.complete();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    private Media[] buildMedia(LLMProvider.LLMRequest request) {
        List<LLMProvider.Attachment> attachments = request.attachments();
        if (attachments == null) {
            return new Media[0];
        }
        return (Media[])attachments.stream().map(SpringAiLLMProvider::getAttachmentMedia).filter(Optional::isPresent).map(Optional::get).toArray(Media[]::new);
    }

    private static Optional<Media> getAttachmentMedia(LLMProvider.Attachment attachment) {
        LLMProviderHelpers.validateAttachment(attachment);
        AttachmentContentType contentType = AttachmentContentType.fromMimeType(attachment.contentType());
        return switch (contentType) {
            default -> throw new MatchException(null, null);
            case AttachmentContentType.TEXT -> Optional.of(SpringAiLLMProvider.getTextMedia(attachment));
            case AttachmentContentType.IMAGE, AttachmentContentType.PDF, AttachmentContentType.AUDIO, AttachmentContentType.VIDEO -> Optional.of(SpringAiLLMProvider.getMedia(attachment));
            case AttachmentContentType.UNSUPPORTED -> Optional.empty();
        };
    }

    private static Media getMedia(LLMProvider.Attachment attachment) {
        MimeType mimeType = MimeType.valueOf((String)attachment.contentType());
        ByteArrayResource resource = new ByteArrayResource(attachment.data());
        return Media.builder().mimeType(mimeType).data((Resource)resource).build();
    }

    private static Media getTextMedia(LLMProvider.Attachment attachment) {
        String textContent = LLMProviderHelpers.decodeAsUtf8(attachment.data(), attachment.fileName(), false);
        String formattedText = LLMProviderHelpers.formatTextAttachment(attachment.fileName(), textContent);
        return Media.builder().mimeType(MimeType.valueOf((String)"text/plain")).data((Object)formattedText).build();
    }
}

