/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.orchestrator;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ai.common.AIAttachment;
import com.vaadin.flow.component.ai.orchestrator.MessageListItemWrapper;
import com.vaadin.flow.component.ai.ui.AIMessage;
import com.vaadin.flow.component.ai.ui.AIMessageList;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.messages.MessageListItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MessageListWrapper
implements AIMessageList {
    private final MessageList messageList;
    private final Map<MessageListItem, AIMessage> itemToMessage = new HashMap<MessageListItem, AIMessage>();

    MessageListWrapper(MessageList messageList) {
        this.messageList = messageList;
    }

    @Override
    public AIMessage addMessage(String text, String userName, List<AIAttachment> attachments) {
        MessageListItemWrapper message = new MessageListItemWrapper(text, userName, attachments);
        this.itemToMessage.put(message.getItem(), message);
        this.messageList.addItem(message.getItem());
        return message;
    }

    @Override
    public void addAttachmentClickListener(AIMessageList.AttachmentClickCallback callback) {
        this.messageList.addAttachmentClickListener((ComponentEventListener & Serializable)clickEvent -> {
            int attIndex;
            AIMessage aiMessage = this.itemToMessage.get(clickEvent.getItem());
            if (aiMessage != null && (attIndex = clickEvent.getItem().getAttachments().indexOf(clickEvent.getAttachment())) >= 0) {
                callback.onAttachmentClick(aiMessage, attIndex);
            }
        });
    }
}

