/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.orchestrator;

import com.vaadin.flow.component.ai.common.AIAttachment;
import com.vaadin.flow.component.ai.common.AttachmentContentType;
import com.vaadin.flow.component.ai.ui.AIMessage;
import com.vaadin.flow.component.messages.MessageListItem;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;

class MessageListItemWrapper
implements AIMessage {
    private static final int THUMBNAIL_MAX_SIZE = 200;
    private final MessageListItem item;

    MessageListItemWrapper(String text, String userName, List<AIAttachment> attachments) {
        this.item = new MessageListItem(text, Instant.now(), userName);
        if (attachments != null && !attachments.isEmpty()) {
            List<MessageListItem.Attachment> messageAttachments = attachments.stream().map(MessageListItemWrapper::toMessageAttachment).toList();
            this.item.setAttachments(messageAttachments);
        }
    }

    MessageListItem getItem() {
        return this.item;
    }

    @Override
    public String getText() {
        return this.item.getText();
    }

    @Override
    public void setText(String text) {
        this.item.setText(text);
    }

    @Override
    public Instant getTime() {
        return this.item.getTime();
    }

    @Override
    public void setTime(Instant time) {
        this.item.setTime(time);
    }

    @Override
    public String getUserName() {
        return this.item.getUserName();
    }

    @Override
    public void appendText(String token) {
        this.item.appendText(token);
    }

    private static MessageListItem.Attachment toMessageAttachment(AIAttachment attachment) {
        AttachmentContentType contentType = AttachmentContentType.fromMimeType(attachment.mimeType());
        String url = contentType == AttachmentContentType.IMAGE ? MessageListItemWrapper.toThumbnailDataUrl(attachment) : null;
        return new MessageListItem.Attachment(attachment.name(), url, attachment.mimeType());
    }

    private static String toThumbnailDataUrl(AIAttachment attachment) {
        try {
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(attachment.data()));
            if (originalImage == null) {
                return MessageListItemWrapper.toDataUrl(attachment);
            }
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            if (originalWidth <= 200 && originalHeight <= 200) {
                return MessageListItemWrapper.toDataUrl(attachment);
            }
            double scale = Math.min(200.0 / (double)originalWidth, 200.0 / (double)originalHeight);
            int scaledWidth = (int)((double)originalWidth * scale);
            int scaledHeight = (int)((double)originalHeight * scale);
            BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, 1);
            Graphics2D g2d = scaledImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)scaledImage, "jpg", outputStream);
            String base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return "data:image/jpeg;base64," + base64;
        }
        catch (IOException e) {
            return MessageListItemWrapper.toDataUrl(attachment);
        }
    }

    private static String toDataUrl(AIAttachment attachment) {
        return "data:" + attachment.mimeType() + ";base64," + Base64.getEncoder().encodeToString(attachment.data());
    }
}

