/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.common;

public enum AttachmentContentType {
    IMAGE,
    TEXT,
    PDF,
    AUDIO,
    VIDEO,
    UNSUPPORTED;


    public static AttachmentContentType fromMimeType(String contentType) {
        if (contentType != null) {
            if (contentType.startsWith("image/")) {
                return IMAGE;
            }
            if (contentType.startsWith("text/")) {
                return TEXT;
            }
            if (contentType.startsWith("application/pdf") || contentType.startsWith("application/x-pdf")) {
                return PDF;
            }
            if (contentType.startsWith("audio/")) {
                return AUDIO;
            }
            if (contentType.startsWith("video/")) {
                return VIDEO;
            }
        }
        return UNSUPPORTED;
    }
}

