/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.provider;

import com.vaadin.flow.component.ai.common.AIAttachment;
import com.vaadin.flow.component.ai.common.ChatMessage;
import com.vaadin.flow.component.ai.provider.LangChain4JLLMProvider;
import com.vaadin.flow.component.ai.provider.SpringAILLMProvider;
import dev.langchain4j.model.chat.StreamingChatModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;
import reactor.core.publisher.Flux;

public interface LLMProvider {
    public static SpringAILLMProvider from(ChatModel chatModel) {
        return new SpringAILLMProvider(chatModel);
    }

    public static SpringAILLMProvider from(ChatClient chatClient) {
        return new SpringAILLMProvider(chatClient);
    }

    public static LangChain4JLLMProvider from(StreamingChatModel streamingChatModel) {
        return new LangChain4JLLMProvider(streamingChatModel);
    }

    public static LangChain4JLLMProvider from(dev.langchain4j.model.chat.ChatModel chatModel) {
        return new LangChain4JLLMProvider(chatModel);
    }

    public Flux<String> stream(LLMRequest var1);

    default public void setHistory(List<ChatMessage> history, Map<String, List<AIAttachment>> attachmentsByMessageId) {
        throw new UnsupportedOperationException("This LLM provider does not support chat history restoration.");
    }

    public static interface LLMRequest
    extends Serializable {
        public String userMessage();

        public List<AIAttachment> attachments();

        public String systemPrompt();

        public Object[] tools();
    }
}

