/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ai.orchestrator;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ai.common.AIAttachment;
import com.vaadin.flow.component.ai.ui.AIFileReceiver;
import com.vaadin.flow.component.upload.UploadManager;
import com.vaadin.flow.server.streams.InMemoryUploadCallback;
import com.vaadin.flow.server.streams.UploadHandler;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class UploadManagerWrapper
implements AIFileReceiver {
    private final UploadManager uploadManager;
    private final List<AIAttachment> pendingAttachments = new CopyOnWriteArrayList<AIAttachment>();

    UploadManagerWrapper(UploadManager uploadManager) {
        this.uploadManager = uploadManager;
        uploadManager.setUploadHandler((UploadHandler)UploadHandler.inMemory((InMemoryUploadCallback & Serializable)(meta, data) -> {
            boolean isDuplicate = this.pendingAttachments.stream().anyMatch(a -> a.name().equals(meta.fileName()));
            if (isDuplicate) {
                throw new IllegalArgumentException("Duplicate file name: " + meta.fileName());
            }
            this.pendingAttachments.add(new AIAttachment(meta.fileName(), meta.contentType(), data));
        }));
        uploadManager.addFileRemovedListener((ComponentEventListener & Serializable)event -> this.pendingAttachments.removeIf(a -> a.name().equals(event.getFileName())));
    }

    @Override
    public List<AIAttachment> takeAttachments() {
        List<AIAttachment> result = List.copyOf(this.pendingAttachments);
        this.pendingAttachments.clear();
        this.uploadManager.clearFileList();
        return result;
    }
}

