/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.accordion;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.accordion.AccordionPanel;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@Tag(value="vaadin-accordion")
@NpmPackage(value="@vaadin/accordion", version="25.0.0-beta5")
@JsModule(value="@vaadin/accordion/src/vaadin-accordion.js")
public class Accordion
extends Component
implements HasSize,
HasStyle {
    private static final String OPENED_PROPERTY = "opened";
    private static final String OPENED_CHANGED_DOM_EVENT = "opened-changed";

    public AccordionPanel add(String summary, Component content) {
        AccordionPanel panel = new AccordionPanel(summary, content);
        return this.add(panel);
    }

    public AccordionPanel add(AccordionPanel panel) {
        Objects.requireNonNull(panel, "The panel to be added cannot be null");
        this.getElement().appendChild(new Element[]{panel.getElement()});
        return panel;
    }

    public void remove(AccordionPanel panel) {
        Objects.requireNonNull(panel, "The panel to be removed cannot be null");
        this.getElement().removeChild(new Element[]{panel.getElement()});
    }

    public void remove(Component content) {
        Optional grandParent;
        Objects.requireNonNull(content, "The content of the panel to be removed cannot be null");
        if (content instanceof AccordionPanel) {
            this.remove((AccordionPanel)content);
            return;
        }
        if (content.getParent().isPresent() && (grandParent = ((Component)content.getParent().get()).getParent()).isPresent() && grandParent.get() instanceof AccordionPanel) {
            this.remove((AccordionPanel)((Object)grandParent.get()));
            return;
        }
        throw new IllegalArgumentException("The supplied content is not a descendant of this Accordion. It can be added with the accordion.add.");
    }

    public void close() {
        this.getElement().setProperty(OPENED_PROPERTY, null);
    }

    public void open(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The index to open cannot be negative");
        }
        this.getElement().setProperty(OPENED_PROPERTY, (double)index);
    }

    public void open(AccordionPanel panel) {
        Objects.requireNonNull(panel, "The panel to be opened cannot be null");
        this.open(this.getElement().indexOfChild(panel.getElement()));
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public OptionalInt getOpenedIndex() {
        String opened = this.getElement().getProperty(OPENED_PROPERTY);
        return opened == null ? OptionalInt.empty() : OptionalInt.of(Integer.valueOf(opened));
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public Optional<AccordionPanel> getOpenedPanel() {
        OptionalInt optionalOpenedIndex = this.getOpenedIndex();
        if (!optionalOpenedIndex.isPresent()) {
            return Optional.empty();
        }
        int index = optionalOpenedIndex.getAsInt();
        return Accordion.getOpenedPanel(this, index);
    }

    private static Optional<AccordionPanel> getOpenedPanel(Accordion accordion, Integer index) {
        return index == null || (long)index.intValue() >= accordion.getChildren().count() ? Optional.empty() : accordion.getElement().getChild(index.intValue()).getComponent().map(AccordionPanel.class::cast);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return ComponentUtil.addListener((Component)this, OpenedChangeEvent.class, listener);
    }

    @DomEvent(value="opened-changed")
    public static class OpenedChangeEvent
    extends ComponentEvent<Accordion> {
        private final Integer index;

        public OpenedChangeEvent(Accordion source, boolean fromClient, @EventData(value="event.detail.value") Integer index) {
            super((Component)source, fromClient);
            this.index = index;
        }

        public OptionalInt getOpenedIndex() {
            return this.index == null ? OptionalInt.empty() : OptionalInt.of(this.index);
        }

        public Optional<AccordionPanel> getOpenedPanel() {
            return Accordion.getOpenedPanel((Accordion)this.getSource(), this.index);
        }
    }
}

