/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.parser;

import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.services.AiLangChainParserService;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.UiRoute;
import com.vaadin.uitest.model.scenario.TestScenarios;
import com.vaadin.uitest.parser.ParserLLM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserAiLangChain
extends ParserLLM<AiLangChainParserService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserAiLangChain.class);

    public ParserAiLangChain() {
    }

    public ParserAiLangChain(String baseUrl) {
        super(baseUrl);
    }

    AiLangChainParserService getService() {
        return (AiLangChainParserService)LLMService.ServiceLocator.createService(AiLangChainParserService.class);
    }

    public void generateTestScenarios(UiRoute view) {
        LOGGER.info("Parsing the view {} ({}) Source: {} Bytes - {} Words", new Object[]{view.getSimpleName(), view.getRoute(), view.getSource().length(), view.getSource().split("[^\\w]+").length});
        Framework framework = Framework.getByValue((String)view.getFramework());
        String tmpl = this.getService().getJavaHtmlTemplate(view.getSource(), view.getHtml());
        String resp = this.getService().getGeneratedResponse(tmpl, framework, view.getGherkin());
        tmpl = this.getService().getGherkinTemplate(new Object[0]);
        resp = this.getService().getGeneratedResponse(tmpl, framework, view.getGherkin());
        tmpl = this.getService().getActionSelectors(new Object[0]);
        resp = this.getService().getGeneratedResponse(tmpl, framework, view.getGherkin());
        view.setGherkin(resp);
        TestScenarios testScenarios = TestScenarios.parse((String)resp);
        view.setTestScenarios(testScenarios);
    }
}

