/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.parser;

import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.services.AiFullParserService;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.browser.Browser;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.UiRoute;
import com.vaadin.uitest.model.scenario.TestScenario;
import com.vaadin.uitest.model.scenario.TestScenarioStep;
import com.vaadin.uitest.model.scenario.TestScenarioStepType;
import com.vaadin.uitest.model.scenario.TestScenarios;
import com.vaadin.uitest.parser.ParserLLM;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserAiFull
extends ParserLLM<AiFullParserService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserAiFull.class);

    public ParserAiFull() {
    }

    public ParserAiFull(String baseUrl) {
        super(baseUrl);
    }

    AiFullParserService getService() {
        return (AiFullParserService)LLMService.ServiceLocator.createService(AiFullParserService.class);
    }

    public void generateTestScenarios(UiRoute view) {
        String gherkinTestScenariosGenerationPrompt = this.getService().getGherkinTestScenariosGenerationTemplate(view.getSource());
        LOGGER.info("Parsing the view {} ({}) Source: {} Bytes - {} Words", new Object[]{view.getSimpleName(), view.getRoute(), view.getSource().length(), view.getSource().split("[^\\w]+").length});
        String gherkinTestScenariosRaw = this.getService().getGeneratedResponse(gherkinTestScenariosGenerationPrompt, Framework.getByValue((String)view.getFramework()), null);
        view.setGherkin(gherkinTestScenariosRaw);
        TestScenarios testScenarios = TestScenarios.parse((String)gherkinTestScenariosRaw);
        view.setTestScenarios(testScenarios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGherkinScenario(String url, String initialDomState, TestScenario gherkinTestScenario, Framework framework) {
        String currentDomState = initialDomState;
        ArrayList<String> jsSnippetsForActions = new ArrayList<String>();
        for (TestScenarioStep step : gherkinTestScenario.getSteps()) {
            if (!TestScenarioStepType.ACTION.equals((Object)step.getType())) continue;
            String updatedUiAction = this.getUpdatedUiAction(this.getService(), currentDomState, step.getDescription(), framework);
            if (updatedUiAction.isBlank()) {
                return;
            }
            step.setDescription(updatedUiAction);
            String jsSnippet = this.getJsSnippet(this.getService(), currentDomState, updatedUiAction, framework);
            if (jsSnippet.isBlank()) {
                return;
            }
            jsSnippetsForActions.add(jsSnippet);
            step.setJsSnippet(jsSnippet);
            try (Browser browser = this.getBrowser();){
                LOGGER.info("Executing action in the view: {} {}", (Object)url, (Object)((Object)jsSnippetsForActions).toString().replace("\n", ""));
                currentDomState = browser.getHTMLContent(url, jsSnippetsForActions);
                step.setResultHtml(PromptUtils.cleanHtml((String)currentDomState));
            }
        }
    }

    private String getJsSnippet(AiFullParserService service, String currentDomState, String updatedUiAction, Framework framework) {
        String uiActionJsSnippetGenerationTemplate = service.getUiActionJsSnippetGenerationTemplate(currentDomState, updatedUiAction);
        String jsSnippetRaw = service.getGeneratedResponse(uiActionJsSnippetGenerationTemplate, framework, null);
        return PromptUtils.cleanJsSnippet((String)jsSnippetRaw);
    }

    private String getUpdatedUiAction(AiFullParserService service, String currentDomState, String uiAction, Framework framework) {
        String updateUiActionTemplate = service.getUpdateUiActionTemplate(currentDomState, uiAction);
        String updatedUiActionRaw = service.getGeneratedResponse(updateUiActionTemplate, framework, null);
        return PromptUtils.cleanUiAction((String)updatedUiActionRaw);
    }
}

