/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services.vectordb;

import com.vaadin.uitest.ai.services.vectordb.DocumentTemplate;
import com.vaadin.uitest.ai.services.vectordb.DocumentsQueryResult;
import com.vaadin.uitest.ai.services.vectordb.Namespace;
import com.vaadin.uitest.ai.utils.KeysUtils;
import com.vaadin.uitest.model.vectordb.Document;
import com.vaadin.uitest.model.vectordb.Match;
import com.vaadin.uitest.model.vectordb.QueryResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class PineconeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PineconeService.class);
    private String PINECONE_API_KEY = KeysUtils.getPineconeKey();
    private String PINECONE_API_URL = KeysUtils.getPineconeUrl();
    private WebClient webClient = WebClient.builder().baseUrl(this.PINECONE_API_URL).defaultHeader("Api-Key", new String[]{this.PINECONE_API_KEY}).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Content-Type", new String[]{"application/json"}).build();

    public Mono<DocumentsQueryResult> findSimilarDocuments(List<Double> embedding, Namespace namespace, int topK) {
        if (Boolean.getBoolean("ai.debug")) {
            LOGGER.info("Finding similar documents in namespace: {}", (Object)namespace.getLabel());
        }
        Map<String, Object> body = Map.of("vector", embedding, "topK", topK, "includeMetadata", true, "namespace", namespace.getLabel());
        return this.getQueryResults(body, namespace);
    }

    private Mono<DocumentsQueryResult> getQueryResults(Map<String, Object> body, Namespace namespace) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/query", new Object[0])).bodyValue(body).retrieve().bodyToMono(QueryResponse.class).map(QueryResponse::getMatches).flatMapIterable(matches -> matches).filter(match -> match.getScore() > namespace.getMatchScoreThreshold()).map(match -> this.getDocumentForTemplate((Match)match, namespace.getDocumentTemplate())).filter(Optional::isPresent).map(Optional::get).filter(doc -> !doc.isBlank()).collectList().map(docs -> new DocumentsQueryResult(namespace, (List<Document>)docs));
    }

    private Optional<Document> getDocumentForTemplate(Match match, DocumentTemplate documentTemplate) {
        if (match.getMetadata() == null || documentTemplate.getRequiredFields().stream().anyMatch(requiredField -> !match.getMetadata().containsKey(requiredField) || match.getMetadata().get(requiredField).isBlank())) {
            return Optional.empty();
        }
        String content = documentTemplate.getContentTemplate().formatted(documentTemplate.getRequiredFields().stream().map(match.getMetadata()::get).toArray());
        Document document = new Document();
        document.setContent(content);
        document.setScore(Float.valueOf(match.getScore().floatValue()));
        document.setLabel(documentTemplate.getLabel());
        documentTemplate.getLinkKey().ifPresent(key -> document.setLink(match.getMetadata().get(key)));
        return Optional.of(document);
    }
}

