/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services.vectordb;

import com.google.common.base.Joiner;
import com.vaadin.uitest.ai.services.AiServiceConstants;
import com.vaadin.uitest.ai.utils.KeysUtils;
import com.vaadin.uitest.model.chat.ChatCompletionChunkResponse;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import com.vaadin.uitest.model.chat.ChatCompletionMessageIn;
import com.vaadin.uitest.model.chat.Link;
import com.vaadin.uitest.model.vectordb.ChatIndexSource;
import com.vaadin.uitest.model.vectordb.EmbeddingResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.annotation.RegisterReflectionForBinding;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class OpenAIService {
    public static final int FLUX_BUFFER_MAX_SIZE = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIService.class);
    private static final String OPENAI_API_KEY = KeysUtils.getOpenAiKey();
    private final WebClient webClient;

    public OpenAIService() {
        HttpClient client = HttpClient.create().responseTimeout(Duration.ofSeconds(45L));
        this.webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(client)).baseUrl("https://api.openai.com").defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Bearer " + OPENAI_API_KEY}).build();
    }

    @RegisterReflectionForBinding(value={EmbeddingResponse.class})
    public Mono<List<Double>> createEmbedding(String text) {
        if (Boolean.getBoolean("ai.debug")) {
            LOGGER.info("Creating embedding for text: {}", (Object)text);
        }
        Map<String, String> body = Map.of("model", AiServiceConstants.MODEL, "input", text);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/embeddings", new Object[0])).bodyValue(body).retrieve().bodyToMono(EmbeddingResponse.class).map(EmbeddingResponse::getEmbedding);
    }

    public Flux<ChatCompletionMessage> generateCompletionStream(List<ChatCompletionMessage> messages, ChatIndexSource indexSource, String sessionId) {
        if (Boolean.getBoolean("ai.debug")) {
            LOGGER.info("Generating completion for messages: {}", messages);
        }
        List links = messages.get(0).getLinks();
        int index = indexSource.get(sessionId);
        float score = messages.get(0).getScore();
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/chat/completions", new Object[0])).bodyValue(Map.of("model", AiServiceConstants.MODEL, "messages", messages.stream().map(msg -> new ChatCompletionMessageIn(ChatCompletionMessageIn.Role.valueOf((String)msg.getRole().name()), msg.getContent())).collect(Collectors.toList()), "stream", true, "temperature", AiServiceConstants.TEMPERATURE)).retrieve().bodyToFlux(ChatCompletionChunkResponse.class).onErrorResume(error -> {
            if (error.getMessage().contains("JsonToken.START_ARRAY")) {
                return Flux.empty();
            }
            return Flux.error((Throwable)error);
        }).filter(response -> {
            String content = ((ChatCompletionChunkResponse.Choice)response.getChoices().get(0)).getDelta().getContent();
            return content != null && !content.equals("\n\n");
        }).map(response -> ((ChatCompletionChunkResponse.Choice)response.getChoices().get(0)).getDelta().getContent()).buffer(10).map(list -> Joiner.on((String)"").join((Iterable)list)).map(val -> {
            if (Boolean.getBoolean("ai.debug")) {
                LOGGER.debug("Received chunk: {}", val);
            }
            return val;
        }).map(content -> new ChatCompletionMessage(null, content, this.getLinksOnce(links), index, score));
    }

    private List<Link> getLinksOnce(List<Link> links) {
        if (!links.isEmpty()) {
            ArrayList<Link> linksToReturn = new ArrayList<Link>(links);
            links.clear();
            return linksToReturn;
        }
        return links;
    }
}

