/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services.vectordb;

import java.util.List;
import java.util.Optional;

public enum DocumentTemplate {
    REGULAR_DOC("Documentation", "path", List.of("article")),
    JAVA_DOC("JavaDocs", "link", List.of("article")),
    RECOMMENDED_ACTIONS("Recommended Action", null, List.of("actionDescription", "recommendedActionCode")),
    FULL_TEST_DATA("Recommended Action with Sample", null, List.of("sampleDescription", "sampleCode", "actionDescription", "recommendedActionCode"));

    private final String label;
    private final String linkKey;
    private final List<String> requiredFields;

    private DocumentTemplate(String label, String linkKey, List<String> requiredFields) {
        this.label = label;
        this.linkKey = linkKey;
        this.requiredFields = requiredFields;
    }

    public Optional<String> getLinkKey() {
        return Optional.ofNullable(this.linkKey);
    }

    public String getContentTemplate() {
        switch (this) {
            case REGULAR_DOC: 
            case JAVA_DOC: {
                return "%s";
            }
            case RECOMMENDED_ACTIONS: {
                return "Action description:\n%s\nRecommended action code:\n%s";
            }
            case FULL_TEST_DATA: {
                return "Sample description:\n%s\nSample code:\n%s\nAction description:\n%s\nRecommended action code:\n%s";
            }
        }
        return "";
    }

    public List<String> getRequiredFields() {
        return this.requiredFields;
    }

    public String getLabel() {
        return this.label;
    }
}

