/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services.vectordb;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.vaadin.uitest.ai.services.vectordb.DocumentTemplate;
import com.vaadin.uitest.ai.services.vectordb.DocumentsQueryResult;
import com.vaadin.uitest.ai.services.vectordb.Namespace;
import com.vaadin.uitest.ai.services.vectordb.OpenAIService;
import com.vaadin.uitest.ai.services.vectordb.PineconeService;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import com.vaadin.uitest.model.chat.Link;
import com.vaadin.uitest.model.vectordb.ChatIndexSource;
import com.vaadin.uitest.model.vectordb.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class DocsAssistantService {
    public static final int LINKS_LIMIT_JAVADOCS = 3;
    public static final int LINKS_LIMIT_DOCUMENTATION = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(DocsAssistantService.class);
    private static final int MAX_TOKENS = 16384;
    private static final int MAX_RESPONSE_TOKENS = 1250;
    private static final int MAX_CONTEXT_TOKENS_DEFAULT = 6144;
    private static final int MAX_DOCS_RESULTS = 20;
    private final OpenAIService openAIService;
    private final PineconeService pineconeService;
    private final Encoding tokenizer;
    private static final String DOCUMENTATION_LINK_PREFIX_FLOW = "https://vaadin.com/docs/latest";
    private static final String DOCUMENTATION_LINK_PREFIX_HILLA_REACT = "https://hilla.dev/docs";
    private static final String DOCUMENTATION_LINK_PREFIX_HILLA_LIT = "https://hilla.dev/docs";
    private static final String JAVADOCS_LINK_PREFIX = "https://vaadin.com/api/platform/24.3.8/";
    private final ChatIndexSource indexSource = new ChatIndexSource();

    public DocsAssistantService(OpenAIService openAIService, PineconeService pineconeService) {
        this.openAIService = openAIService;
        this.pineconeService = pineconeService;
        EncodingRegistry registry = Encodings.newDefaultEncodingRegistry();
        this.tokenizer = registry.getEncoding(EncodingType.CL100K_BASE);
    }

    public Flux<ChatCompletionMessage> getCompletionStream(List<ChatCompletionMessage> history, Framework framework, String question, String sessionId, boolean forParser) {
        Map<Namespace, Integer> namespacesWithMaxDocumentCount;
        LOGGER.info("History size {}, {}", (Object)history.size(), (Object)framework);
        if (history.isEmpty()) {
            return Flux.error((Throwable)new RuntimeException("History is empty"));
        }
        Map<Namespace, Integer> map = namespacesWithMaxDocumentCount = forParser ? this.getParserNamespacesWithMaxDocumentCount(framework) : this.getGeneratorNamespacesWithMaxDocumentCount(framework);
        assert (namespacesWithMaxDocumentCount.values().stream().mapToInt(Integer::intValue).sum() <= 20);
        if (question == null) {
            question = history.get(history.size() - 1).getContent();
        }
        return this.openAIService.createEmbedding(question).flatMapMany(embedding -> Flux.fromIterable(namespacesWithMaxDocumentCount.keySet()).flatMap(namespace -> this.pineconeService.findSimilarDocuments((List<Double>)embedding, (Namespace)((Object)((Object)namespace)), (Integer)namespacesWithMaxDocumentCount.get(namespace)))).collectList().map(documentsQueryResult -> this.getPromptWithContext(history, framework, (List<DocumentsQueryResult>)documentsQueryResult, forParser)).flatMapMany(prompts -> this.openAIService.generateCompletionStream((List<ChatCompletionMessage>)prompts, this.indexSource, sessionId));
    }

    private int getMaxContextTokens(Framework framework, Namespace namespace, boolean forParser) {
        Map<Namespace, Integer> namespacesWithMaxDocumentCount = forParser ? this.getParserNamespacesWithMaxDocumentCount(framework) : this.getGeneratorNamespacesWithMaxDocumentCount(framework);
        int maxDocumentCount = namespacesWithMaxDocumentCount.values().stream().mapToInt(Integer::intValue).sum();
        int totalMaxContextTokens = forParser ? 1536 : 6144;
        return namespacesWithMaxDocumentCount.get((Object)namespace) * totalMaxContextTokens / maxDocumentCount;
    }

    private Map<Namespace, Integer> getParserNamespacesWithMaxDocumentCount(Framework framework) {
        HashMap<Namespace, Integer> namespacesWithMaxDocumentCount = new HashMap<Namespace, Integer>();
        switch (framework) {
            case FLOW: {
                namespacesWithMaxDocumentCount.put(Namespace.FLOW, 12);
                break;
            }
            case LIT: {
                namespacesWithMaxDocumentCount.put(Namespace.LIT, 12);
                break;
            }
            case REACT: {
                namespacesWithMaxDocumentCount.put(Namespace.REACT, 12);
            }
        }
        return namespacesWithMaxDocumentCount;
    }

    private Map<Namespace, Integer> getGeneratorNamespacesWithMaxDocumentCount(Framework framework) {
        HashMap<Namespace, Integer> namespacesWithMaxDocumentCount = new HashMap<Namespace, Integer>();
        return namespacesWithMaxDocumentCount;
    }

    private List<ChatCompletionMessage> getPromptWithContext(List<ChatCompletionMessage> history, Framework framework, List<DocumentsQueryResult> documentsQueryResults, boolean forParser) {
        if (documentsQueryResults.stream().map(DocumentsQueryResult::getDocs).allMatch(Collection::isEmpty)) {
            return history;
        }
        ArrayList<ChatCompletionMessage> systemMessages = new ArrayList<ChatCompletionMessage>(history);
        List<ChatCompletionMessage> chatCompletionMessages = documentsQueryResults.stream().filter(documentsQueryResult -> !documentsQueryResult.getDocs().isEmpty()).map(documentsQueryResult -> this.getChatCompletionMessage(framework, (DocumentsQueryResult)documentsQueryResult, forParser)).toList();
        systemMessages.addAll(chatCompletionMessages);
        return this.capMessages(systemMessages);
    }

    private ChatCompletionMessage getChatCompletionMessage(Framework framework, DocumentsQueryResult documentsQueryResult, boolean forParser) {
        String messageTemplate = this.getMessageTemplate(framework, documentsQueryResult.getNamespace().getDocumentTemplate());
        String contextString = this.getContextString(documentsQueryResult.getDocs(), this.getMaxContextTokens(framework, documentsQueryResult.getNamespace(), forParser));
        ChatCompletionMessage chatCompletionMessage = new ChatCompletionMessage(ChatCompletionMessage.Role.USER, String.format(messageTemplate, contextString));
        chatCompletionMessage.addLinks(this.createLinks(documentsQueryResult.getDocs(), framework, documentsQueryResult.getNamespace().getDocumentTemplate(), this.getLinksLimit(documentsQueryResult.getNamespace())));
        chatCompletionMessage.setScore(this.calculateScore(documentsQueryResult.getDocs()));
        return chatCompletionMessage;
    }

    private String getMessageDescription(Framework framework, DocumentTemplate documentTemplate) {
        switch (documentTemplate) {
            case JAVA_DOC: {
                return "Here is the summary of related Vaadin Javadocs API:";
            }
            case REGULAR_DOC: {
                return "Here are a few selected pieces of latest VAADIN " + framework + " documentation:";
            }
            case RECOMMENDED_ACTIONS: {
                return "When implementing a scenario step, please consider the following Playwright Java code snippets as references:";
            }
            case FULL_TEST_DATA: {
                return String.format("Here are the %s samples and recommended Playwright Java actions for reference:", framework.getLabel());
            }
        }
        return "";
    }

    private String getMessageTemplate(Framework framework, DocumentTemplate documentTemplate) {
        return "%s\n===\n%s\n===\n".formatted(this.getMessageDescription(framework, documentTemplate), "%s");
    }

    private int getLinksLimit(Namespace namespace) {
        return DocumentTemplate.JAVA_DOC.equals((Object)namespace.getDocumentTemplate()) ? 3 : 2;
    }

    private float calculateScore(List<Document> documents) {
        return documents.stream().map(Document::getScore).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private Collection<Link> createLinks(List<Document> documents, Framework framework, DocumentTemplate documentTemplate, int limit) {
        return documents.stream().map(Document::getLink).filter(Objects::nonNull).distinct().limit(limit).map(link -> new Link(documentTemplate.getLabel(), this.createRealLink((String)link, framework, documentTemplate))).toList();
    }

    private String createRealLink(String link, Framework framework, DocumentTemplate documentTemplate) {
        if (DocumentTemplate.JAVA_DOC.equals((Object)documentTemplate)) {
            if (Boolean.getBoolean("ai.debug")) {
                LOGGER.info("Created Javadoc link {}", (Object)(JAVADOCS_LINK_PREFIX + link));
            }
            return JAVADOCS_LINK_PREFIX + link;
        }
        String documentationLinkPrefix = DOCUMENTATION_LINK_PREFIX_FLOW;
        if (Framework.REACT.equals((Object)framework)) {
            documentationLinkPrefix = "https://hilla.dev/docs";
        } else if (Framework.LIT.equals((Object)framework)) {
            documentationLinkPrefix = "https://hilla.dev/docs";
        }
        if (!link.isBlank()) {
            String articleLink = link.substring(link.indexOf("dspublisher/out/public") + 23 + framework.getValue().length(), link.length() - 11);
            if (Boolean.getBoolean("ai.debug")) {
                LOGGER.info("Created link {}", (Object)(documentationLinkPrefix + articleLink));
            }
            return documentationLinkPrefix + articleLink;
        }
        if (Boolean.getBoolean("ai.debug")) {
            LOGGER.info("Created default link {}", (Object)documentationLinkPrefix);
        }
        return documentationLinkPrefix;
    }

    private String getContextString(List<Document> contextDocs, int maxTokens) {
        int tokenCount = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Document doc : contextDocs) {
            if ((tokenCount += this.tokenizer.encode(doc.getContent() + "\n---\n").size()) > maxTokens) break;
            stringBuilder.append(doc.getContent());
            stringBuilder.append("\n---\n");
            if (!Boolean.getBoolean("ai.debug")) continue;
            LOGGER.info("Appended a doc with score {}, doc: {} ", (Object)doc.getScore(), (Object)doc.getContent());
        }
        LOGGER.info("ContextDocs article count {}, context formed with {}/{} tokens", new Object[]{contextDocs.size(), tokenCount, maxTokens});
        return stringBuilder.toString();
    }

    private List<ChatCompletionMessage> capMessages(List<ChatCompletionMessage> systemMessages) {
        int availableTokens = 15134;
        int tokens = this.getTokenCount(systemMessages);
        LOGGER.info("Current total context size {} tokens", (Object)tokens);
        while (tokens > availableTokens) {
            systemMessages.remove(systemMessages.remove(systemMessages.size() - 1));
            tokens = this.getTokenCount(systemMessages);
            LOGGER.info("Messages capped to {} entries to reduce tokens, current context size {} tokens", (Object)systemMessages.size(), (Object)tokens);
        }
        return new ArrayList<ChatCompletionMessage>(systemMessages);
    }

    private int getTokenCount(List<ChatCompletionMessage> messages) {
        int tokenCount = 3;
        for (ChatCompletionMessage message : messages) {
            tokenCount += this.getMessageTokenCount(message);
        }
        return tokenCount;
    }

    private int getMessageTokenCount(ChatCompletionMessage message) {
        int tokens = 4;
        tokens += this.tokenizer.encode(message.getRole().toString()).size();
        return tokens += this.tokenizer.encode(message.getContent()).size();
    }

    public void resetIndexSource(String sessionId) {
        this.indexSource.reset(sessionId);
    }
}

