/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.utils.KeysUtils;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public abstract class DefaultLLMService
implements LLMService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLLMService.class);

    public DefaultLLMService() {
        LOGGER.info("Using the {} model with {} of temperature {} of max-tokens, and a timeout of {} secs.", new Object[]{this.getModel(), this.getTemperature(), this.getMaxTokens(), LLMService.getTimeout()});
    }

    public String requestAI(AiArguments aiArguments) {
        return OpenAiChatModel.builder().apiKey(KeysUtils.getOpenAiKey()).modelName(aiArguments.getModel()).maxTokens(Integer.valueOf(this.getMaxTokens())).temperature(Double.valueOf(this.getTemperature())).timeout(Duration.ofSeconds(LLMService.getTimeout())).build().generate(aiArguments.getPrompt());
    }

    protected static String fluxToString(Flux<ChatCompletionMessage> flux) {
        try {
            long timeoutDuration = 60L;
            return (String)flux.collectList().map(completion -> completion.stream().map(ChatCompletionMessage::getContent).collect(Collectors.joining(""))).subscribeOn(Schedulers.boundedElastic()).toFuture().get(timeoutDuration, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("Error while waiting for the completion", (Throwable)e);
            throw new RuntimeException("Operation timed out or was interrupted", e);
        }
    }
}

