/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.services.AiAssistantParserService;
import com.vaadin.uitest.ai.services.AiServiceConstants;
import com.vaadin.uitest.ai.services.DefaultLLMService;
import com.vaadin.uitest.ai.services.vectordb.DocsAssistantService;
import com.vaadin.uitest.ai.services.vectordb.OpenAIService;
import com.vaadin.uitest.ai.services.vectordb.PineconeService;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AiVectorDBParserService
extends AiAssistantParserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiVectorDBParserService.class);
    private final DocsAssistantService docsAssistantService;

    public AiVectorDBParserService() {
        LOGGER.info("Using the {} model", (Object)this.getModel());
        OpenAIService openAIService = new OpenAIService();
        PineconeService pineconeService = new PineconeService();
        this.docsAssistantService = new DocsAssistantService(openAIService, pineconeService);
    }

    public String requestAI(AiArguments aiArguments) {
        ArrayList<ChatCompletionMessage> history = new ArrayList<ChatCompletionMessage>();
        history.add(new ChatCompletionMessage(ChatCompletionMessage.Role.SYSTEM, this.getChatAssistantSystemMessage("Bart", aiArguments.getFramework())));
        history.add(new ChatCompletionMessage(ChatCompletionMessage.Role.USER, aiArguments.getPrompt()));
        String id = UUID.randomUUID().toString();
        Flux<ChatCompletionMessage> flux = this.docsAssistantService.getCompletionStream(history, aiArguments.getFramework(), aiArguments.getSource(), id, true);
        return DefaultLLMService.fluxToString(flux).replaceAll("([^\n])( *)(Scenario|Given|When|And|Then)(:)", "$1\n$2$3$4");
    }

    public String getModel() {
        return AiServiceConstants.MODEL;
    }
}

