/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.prompts.AiSnippets;
import com.vaadin.uitest.ai.services.AiServiceConstants;
import com.vaadin.uitest.ai.services.DefaultLLMService;
import com.vaadin.uitest.ai.services.vectordb.DocsAssistantService;
import com.vaadin.uitest.ai.services.vectordb.OpenAIService;
import com.vaadin.uitest.ai.services.vectordb.PineconeService;
import com.vaadin.uitest.model.TestFramework;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AiVectorDBGeneratorService
implements LLMService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiVectorDBGeneratorService.class);
    private final DocsAssistantService docsAssistantService;

    public AiVectorDBGeneratorService() {
        LOGGER.info("Using the {} model", (Object)this.getModel());
        OpenAIService openAIService = new OpenAIService();
        PineconeService pineconeService = new PineconeService();
        this.docsAssistantService = new DocsAssistantService(openAIService, pineconeService);
    }

    public String getPromptTemplate(AiArguments aiArguments) {
        TestFramework testFramework = aiArguments.getTestFramework();
        if (testFramework == null) {
            testFramework = aiArguments.getFramework().getDefaultTestFramework();
        }
        List codeSnippets = AiSnippets.getCodeSnippets((AiArguments)aiArguments);
        String codeSnippetsArg = AiSnippets.getCodeSnippetsArg((List)codeSnippets);
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder promptBuilder = new StringBuilder();
        if (TestFramework.PLAYWRIGHT_NODE.equals((Object)testFramework)) {
            promptBuilder.append(this.prompts().get("GENERATE_HEADING_PLAYWRIGHT_REACT"));
            arguments.add(aiArguments.getFramework().getLabel());
            arguments.add(aiArguments.getGherkin());
            arguments.add(aiArguments.getViewUrl());
        } else {
            promptBuilder.append(this.prompts().get("GENERATE_HEADING_PLAYWRIGHT_JAVA"));
            arguments.add(aiArguments.getFramework().getLabel());
            arguments.add(aiArguments.getGherkin());
            arguments.add(aiArguments.getTestClassName());
            arguments.add(aiArguments.getViewUrl());
        }
        promptBuilder.append(this.prompts().get("GENERATE_IMPORTS"));
        arguments.add(AiSnippets.getImportsArg((TestFramework)testFramework, (List)codeSnippets));
        promptBuilder.append(this.prompts().get("GENERATE_SNIPPETS"));
        arguments.add(codeSnippetsArg);
        return String.format(promptBuilder.toString(), arguments.toArray());
    }

    public String requestAI(AiArguments aiArguments) {
        ArrayList<ChatCompletionMessage> history = new ArrayList<ChatCompletionMessage>();
        history.add(new ChatCompletionMessage(ChatCompletionMessage.Role.ASSISTANT, this.getChatAssistantSystemMessage("Bart", aiArguments.getFramework())));
        history.add(new ChatCompletionMessage(ChatCompletionMessage.Role.USER, aiArguments.getPrompt()));
        String id = UUID.randomUUID().toString();
        Flux<ChatCompletionMessage> flux = this.docsAssistantService.getCompletionStream(history, aiArguments.getFramework(), aiArguments.getGherkin(), id, false);
        return DefaultLLMService.fluxToString(flux);
    }

    public String getModel() {
        return AiServiceConstants.MODEL;
    }
}

