/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.services.DefaultLLMService;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.Framework;
import dev.ai4j.openai4j.OpenAiHttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiLiteParserService
extends DefaultLLMService {
    private static final String PARSER_LITE_AI_QUESTION = "PARSER_LITE_AI_QUESTION";
    private static final Logger LOGGER = LoggerFactory.getLogger(AiLiteParserService.class);
    private static final int MAX_REQUEST_RETRY_COUNT = 3;
    private static final int REQUEST_RETRY_DELAY_SECONDS = 30;

    public String getPromptTemplate(AiArguments aiArguments) {
        return String.format(this.prompts().get(PARSER_LITE_AI_QUESTION), PromptUtils.cleanJavaCode((String)aiArguments.getSource()), PromptUtils.cleanHtml((String)aiArguments.getHtml()));
    }

    public String getGeneratedResponse(String prompt, Framework framework, String gherkin) {
        int requestNumber = 0;
        while (true) {
            ++requestNumber;
            try {
                AiArguments aiArguments = new AiArguments();
                aiArguments.setPrompt(prompt);
                aiArguments.setModel(this.getModel());
                aiArguments.setFramework(framework);
                return this.getGeneratedResponse(aiArguments);
            }
            catch (OpenAiHttpException e1) {
                LOGGER.error("Exception requesting AI {}", (Object)e1.getMessage());
                if (requestNumber == 3) {
                    throw e1;
                }
                try {
                    LOGGER.info("Retrying request {} of 3 in 30secs.", (Object)requestNumber);
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

