/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.utils.KeysUtils;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.Framework;
import dev.langchain4j.chain.ConversationalChain;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiLangChainParserService
implements LLMService {
    private static final String PARSER_LANGCHAIN_GHERKIN_SCENARIOS = "PARSER_LANGCHAIN_GHERKIN_SCENARIOS";
    private static final String PARSER_LANGCHAIN_SNIPPETS = "PARSER_LANGCHAIN_SNIPPETS";
    private static final Logger LOGGER = LoggerFactory.getLogger(AiLangChainParserService.class);
    private final ConversationalChain chain;

    public AiLangChainParserService() {
        LOGGER.info("Using the {} model", (Object)this.getModel());
        this.chain = ConversationalChain.builder().chatLanguageModel((ChatLanguageModel)OpenAiChatModel.withApiKey((String)KeysUtils.getOpenAiKey())).build();
    }

    public String getJavaHtmlTemplate(Object ... args) {
        return String.format(this.prompts().get("PARSER_ASSISTANT_QUESTION"), args[0], args[0], PromptUtils.cleanSourceCode((String)((String)args[1]), (Framework)((Framework)args[0])), PromptUtils.cleanHtml((String)((String)args[2])));
    }

    public String getPromptTemplate(AiArguments aiArguments) {
        return this.getJavaHtmlTemplate(aiArguments.getFramework(), aiArguments.getSource(), aiArguments.getHtml());
    }

    public String getGherkinTemplate(Object ... args) {
        return String.format(this.prompts().get(PARSER_LANGCHAIN_GHERKIN_SCENARIOS), args);
    }

    public String getActionSelectors(Object ... args) {
        return String.format(this.prompts().get(PARSER_LANGCHAIN_SNIPPETS), args);
    }

    public String requestAI(AiArguments aiArguments) {
        return this.chain.execute(aiArguments.getPrompt());
    }
}

