package com.vaadin.uitest.parser;

import com.vaadin.uitest.ai.LLMService.ServiceLocator;
import com.vaadin.uitest.ai.services.AiLangChainParserService;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.UiRoute;
import com.vaadin.uitest.model.scenario.TestScenarios;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserAiLangChain extends ParserLLM<AiLangChainParserService> {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(ParserAiLangChain.class);

    public ParserAiLangChain() {
    }

    public ParserAiLangChain(String baseUrl) {
        super(baseUrl);
    }

    @Override
    AiLangChainParserService getService() {
        return ServiceLocator.createService(AiLangChainParserService.class);
    }

    @Override
    public void generateTestScenarios(UiRoute view) {
        LOGGER.info("Parsing the view {} ({}) Source: {} Bytes - {} Words",
                view.getSimpleName(), view.getRoute(),
                view.getSource().length(),
                view.getSource().split("[^\\w]+").length);

        Framework framework = Framework.getByValue(view.getFramework());

        String tmpl = getService().getJavaHtmlTemplate(view.getSource(),
                view.getHtml());
        String resp = getService().getGeneratedResponse(tmpl, framework,
                view.getGherkin());

        tmpl = getService().getGherkinTemplate();
        resp = getService().getGeneratedResponse(tmpl, framework,
                view.getGherkin());

        tmpl = getService().getActionSelectors();
        resp = getService().getGeneratedResponse(tmpl, framework,
                view.getGherkin());
        view.setGherkin(resp);

        TestScenarios testScenarios = TestScenarios.parse(resp);
        view.setTestScenarios(testScenarios);
    }

}
