package com.vaadin.uitest.parser;

import java.util.ArrayList;
import java.util.List;

import com.vaadin.uitest.ai.LLMService.ServiceLocator;
import com.vaadin.uitest.ai.services.AiFullParserService;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.browser.Browser;
import com.vaadin.uitest.model.UiRoute;
import com.vaadin.uitest.model.Framework;
import com.vaadin.uitest.model.scenario.TestScenario;
import com.vaadin.uitest.model.scenario.TestScenarioStep;
import com.vaadin.uitest.model.scenario.TestScenarios;
import com.vaadin.uitest.model.scenario.TestScenarioStepType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserAiFull extends ParserLLM<AiFullParserService> {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(ParserAiFull.class);

    public ParserAiFull() {
    }

    public ParserAiFull(String baseUrl) {
        super(baseUrl);
    }

    @Override
    AiFullParserService getService() {
        return ServiceLocator.createService(AiFullParserService.class);
    }

    @Override
    public void generateTestScenarios(UiRoute view) {
        String gherkinTestScenariosGenerationPrompt = getService()
                .getGherkinTestScenariosGenerationTemplate(view.getSource());
        LOGGER.info("Parsing the view {} ({}) Source: {} Bytes - {} Words",
                view.getSimpleName(), view.getRoute(),
                view.getSource().length(),
                view.getSource().split("[^\\w]+").length);

        String gherkinTestScenariosRaw = getService().getGeneratedResponse(
                gherkinTestScenariosGenerationPrompt,
                Framework.getByValue(view.getFramework()), null);
        view.setGherkin(gherkinTestScenariosRaw);

        TestScenarios testScenarios = TestScenarios
                .parse(gherkinTestScenariosRaw);
        view.setTestScenarios(testScenarios);
    }

    @Override
    protected void updateGherkinScenario(String url, String initialDomState,
            TestScenario gherkinTestScenario, Framework framework) {
        String currentDomState = initialDomState;
        List<String> jsSnippetsForActions = new ArrayList<>();
        for (TestScenarioStep step : gherkinTestScenario.getSteps()) {
            if (!TestScenarioStepType.ACTION.equals(step.getType())) {
                continue;
            }
            String updatedUiAction = getUpdatedUiAction(getService(),
                    currentDomState, step.getDescription(), framework);
            if (updatedUiAction.isBlank()) {
                return;
            }
            step.setDescription(updatedUiAction);
            String jsSnippet = getJsSnippet(getService(), currentDomState,
                    updatedUiAction, framework);
            if (jsSnippet.isBlank()) {
                return;
            }
            jsSnippetsForActions.add(jsSnippet);
            step.setJsSnippet(jsSnippet);
            Browser browser = getBrowser();
            try {
                LOGGER.info("Executing action in the view: {} {}", url,
                        jsSnippetsForActions.toString().replace("\n", ""));
                currentDomState = browser.getHTMLContent(url,
                        jsSnippetsForActions);
                step.setResultHtml(PromptUtils.cleanHtml(currentDomState));
            } catch (Exception e) {
                LOGGER.error(
                        "Ignoring action, Exception when visiting URL={} {}",
                        url, e.getMessage().split("\\R")[0]);
                return;
            } finally {
                browser.close();
            }
        }
    }

    private String getJsSnippet(AiFullParserService service,
            String currentDomState, String updatedUiAction,
            Framework framework) {
        String uiActionJsSnippetGenerationTemplate = service
                .getUiActionJsSnippetGenerationTemplate(currentDomState,
                        updatedUiAction);
        // TODO update prompt to be more stable and return empty for error
        String jsSnippetRaw = service.getGeneratedResponse(
                uiActionJsSnippetGenerationTemplate, framework, null);
        return PromptUtils.cleanJsSnippet(jsSnippetRaw);
    }

    private String getUpdatedUiAction(AiFullParserService service,
            String currentDomState, String uiAction, Framework framework) {
        String updateUiActionTemplate = service
                .getUpdateUiActionTemplate(currentDomState, uiAction);
        // TODO update prompt to be more stable and return empty for error
        String updatedUiActionRaw = service
                .getGeneratedResponse(updateUiActionTemplate, framework, null);
        return PromptUtils.cleanUiAction(updatedUiActionRaw);
    }

}
