package com.vaadin.uitest.model.vectordb;

import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

import java.util.HashMap;
import java.util.Map;

@Component
@ApplicationScope
public class ChatIndexSource {
    private Map<String, Integer> runningIndex = new HashMap<>();

    public int get(String sessionId) {
        Integer index = runningIndex.get(sessionId);
        if (index == null) {
            runningIndex.put(sessionId, 4);
            return 2;
        }
        runningIndex.put(sessionId, index + 2);
        return index;
    }

    public void reset(String sessionId) {
        runningIndex.put(sessionId, 1);
    }
}
