package com.vaadin.uitest.ai.services.vectordb;

public enum Namespace {
    FLOW("flow", DocumentTemplate.REGULAR_DOC, 0.40),

    LIT("lit", DocumentTemplate.REGULAR_DOC, 0.40),

    REACT("react", DocumentTemplate.REGULAR_DOC, 0.40),

    FLOW_API("flow-api-v24", DocumentTemplate.JAVA_DOC, 0.30),

    PLAYWRIGHT_API("playwright-api-v1-43", DocumentTemplate.JAVA_DOC, 0.30),

    RECOMMENDED_ACTIONS("recommended-playwright-java-actions",
            DocumentTemplate.RECOMMENDED_ACTIONS, 0.40),

    FULL_TEST_DATA("playwright-java-full-test-data",
            DocumentTemplate.FULL_TEST_DATA, 0.40);

    private final String label;

    private final DocumentTemplate documentTemplate;

    private final Double matchScoreThreshold;

    Namespace(String label, DocumentTemplate documentTemplate,
            Double matchScoreThreshold) {
        this.label = label;
        this.documentTemplate = documentTemplate;
        this.matchScoreThreshold = matchScoreThreshold;
    }

    public String getLabel() {
        return label;
    }

    public DocumentTemplate getDocumentTemplate() {
        return documentTemplate;
    }

    public Double getMatchScoreThreshold() {
        return matchScoreThreshold;
    }
}
