package com.vaadin.uitest.ai.services.vectordb;

import java.util.List;
import java.util.Optional;

public enum DocumentTemplate {

    REGULAR_DOC("Documentation", "path", List.of("article")),

    JAVA_DOC("JavaDocs", "link", List.of("article")),

    RECOMMENDED_ACTIONS("Recommended Action", null,
            List.of("actionDescription", "recommendedActionCode")),

    FULL_TEST_DATA("Recommended Action with Sample", null,
            List.of("sampleDescription", "sampleCode", "actionDescription",
                    "recommendedActionCode"));

    private final String label;
    private final String linkKey;
    private final List<String> requiredFields;

    DocumentTemplate(String label, String linkKey,
            List<String> requiredFields) {
        this.label = label;
        this.linkKey = linkKey;
        this.requiredFields = requiredFields;
    }

    public Optional<String> getLinkKey() {
        return Optional.ofNullable(linkKey);
    }

    public String getContentTemplate() {
        // Workaround for maven-plugin-plugin multiline string issue
        switch (this) {
        case REGULAR_DOC, JAVA_DOC -> {
            return "%s";
        }
        case RECOMMENDED_ACTIONS -> {
            return """
                    Action description:
                    %s
                    Recommended action code:
                    %s""";
        }
        case FULL_TEST_DATA -> {
            return """
                    Sample description:
                    %s
                    Sample code:
                    %s
                    Action description:
                    %s
                    Recommended action code:
                    %s""";
        }
        }
        return "";
    }

    public List<String> getRequiredFields() {
        return requiredFields;
    }

    public String getLabel() {
        return label;
    }
}
