package com.vaadin.uitest.ai.services;

import static com.vaadin.uitest.ai.services.AiServiceConstants.MODEL;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.services.vectordb.DocsAssistantService;
import com.vaadin.uitest.ai.services.vectordb.OpenAIService;
import com.vaadin.uitest.ai.services.vectordb.PineconeService;
import com.vaadin.uitest.model.chat.ChatCompletionMessage;
import com.vaadin.uitest.model.chat.ChatCompletionMessage.Role;

import reactor.core.publisher.Flux;

public class AiVectorDBParserService extends AiAssistantParserService {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(AiVectorDBParserService.class);

    private final DocsAssistantService docsAssistantService;

    public AiVectorDBParserService() {
        LOGGER.info("Using the {} model", getModel());
        OpenAIService openAIService = new OpenAIService();
        PineconeService pineconeService = new PineconeService();
        this.docsAssistantService = new DocsAssistantService(openAIService,
                pineconeService);
    }

    @Override
    public String requestAI(AiArguments aiArguments) {
        List<ChatCompletionMessage> history = new ArrayList<>();
        history.add(new ChatCompletionMessage(Role.SYSTEM,
                getChatAssistantSystemMessage("Bart",
                        aiArguments.getFramework())));
        history.add(
                new ChatCompletionMessage(Role.USER, aiArguments.getPrompt()));

        String id = UUID.randomUUID().toString();
        Flux<ChatCompletionMessage> flux = docsAssistantService
                .getCompletionStream(history, aiArguments.getFramework(),
                        aiArguments.getSource(), id, true);

        return DefaultLLMService.fluxToString(flux).replaceAll(
                "([^\n])( *)(Scenario|Given|When|And|Then)(:)", "$1\n$2$3$4");
    }

    @Override
    public String getModel() {
        return MODEL;
    }
}
