package com.vaadin.uitest.ai.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.Framework;

import dev.ai4j.openai4j.OpenAiHttpException;

public class AiLiteParserService extends DefaultLLMService {

    private static final String PARSER_LITE_AI_QUESTION = "PARSER_LITE_AI_QUESTION";

    private static final Logger LOGGER = LoggerFactory
            .getLogger(AiLiteParserService.class);

    private static final int MAX_REQUEST_RETRY_COUNT = 3;

    private static final int REQUEST_RETRY_DELAY_SECONDS = 30;

    @Override
    public String getPromptTemplate(AiArguments aiArguments) {
        return String.format(prompts().get(PARSER_LITE_AI_QUESTION),
                PromptUtils.cleanJavaCode(aiArguments.getSource()),
                PromptUtils.cleanHtml(aiArguments.getHtml()));
    }

    @Override
    public String getGeneratedResponse(String prompt, Framework framework,
            String gherkin) {
        int requestNumber = 0;
        while (true) {
            requestNumber++;
            try {
                AiArguments aiArguments = new AiArguments();
                aiArguments.setPrompt(prompt);
                aiArguments.setModel(getModel());
                aiArguments.setFramework(framework);
                return getGeneratedResponse(aiArguments);
            } catch (OpenAiHttpException e1) {
                LOGGER.error("Exception requesting AI {}", e1.getMessage());
                if (requestNumber == MAX_REQUEST_RETRY_COUNT) {
                    throw e1;
                }
                try {
                    LOGGER.info("Retrying request {} of "
                            + MAX_REQUEST_RETRY_COUNT + " in "
                            + REQUEST_RETRY_DELAY_SECONDS + "secs.",
                            requestNumber);
                    Thread.sleep(1000 * REQUEST_RETRY_DELAY_SECONDS);
                } catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

}
