package com.vaadin.uitest.ai.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.vaadin.uitest.ai.AiArguments;

public class AiLiteGeneratorService extends DefaultLLMService {
    private static final String GENERATE_LITE_AI = "GENERATE_LITE_AI";

    public String getPrompt() {
        return prompts().get(GENERATE_HEADING_PLAYWRIGHT_JAVA)
                + prompts().get(GENERATE_LITE_AI);
    }

    @Override
    public String getPromptTemplate(AiArguments aiArguments) {
        List<Object> arguments = new ArrayList<>();
        arguments.add(aiArguments.getFramework().getLabel());
        arguments.add(aiArguments.getGherkin());
        arguments.add(aiArguments.getTestClassName());
        arguments.add(aiArguments.getViewUrl());
        arguments.add(aiArguments.getImports());
        String prompt = getPrompt();
        if (aiArguments.getLogin() != null
                && aiArguments.getLogin().getLoginUrl() != null) {
            arguments.addAll(Arrays.asList(aiArguments.getLogin().asArgs()));
            prompt += prompts().get(GENERATE_LOGIN_PLAYWRIGHT_JAVA);
        }
        return String.format(prompt, arguments.toArray());
    }
}
