package com.vaadin.uitest.ai.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.uitest.ai.AiArguments;
import com.vaadin.uitest.ai.LLMService;
import com.vaadin.uitest.ai.utils.KeysUtils;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.Framework;

import dev.langchain4j.chain.ConversationalChain;
import dev.langchain4j.model.openai.OpenAiChatModel;

public class AiLangChainParserService implements LLMService {
    private static final String PARSER_LANGCHAIN_GHERKIN_SCENARIOS = "PARSER_LANGCHAIN_GHERKIN_SCENARIOS";
    private static final String PARSER_LANGCHAIN_SNIPPETS = "PARSER_LANGCHAIN_SNIPPETS";

    private static final Logger LOGGER = LoggerFactory
            .getLogger(AiLangChainParserService.class);

    private final ConversationalChain chain;

    public AiLangChainParserService() {
        LOGGER.info("Using the {} model", getModel());
        chain = ConversationalChain.builder()
                .chatLanguageModel(
                        OpenAiChatModel.withApiKey(KeysUtils.getOpenAiKey()))
                // .chatMemory() // you can override default chat memory
                .build();
    }

    public String getJavaHtmlTemplate(Object... args) {
        return String.format(prompts().get(PARSER_ASSISTANT_QUESTION), args[0],
                args[0],
                PromptUtils.cleanSourceCode((String) args[1],
                        (Framework) args[0]),
                PromptUtils.cleanHtml((String) args[2]));
    }

    @Override
    public String getPromptTemplate(AiArguments aiArguments) {
        return getJavaHtmlTemplate(aiArguments.getFramework(),
                aiArguments.getSource(), aiArguments.getHtml());
    }

    public String getGherkinTemplate(Object... args) {
        return String.format(prompts().get(PARSER_LANGCHAIN_GHERKIN_SCENARIOS),
                args);
    }

    public String getActionSelectors(Object... args) {
        return String.format(prompts().get(PARSER_LANGCHAIN_SNIPPETS), args);
    }

    @Override
    public String requestAI(AiArguments aiArguments) {
        return chain.execute(aiArguments.getPrompt());
    }

}
