package com.vaadin.uitest.ai.services;

import com.vaadin.uitest.ai.utils.PromptUtils;

public class AiFullParserService extends AiLiteParserService {

    private static final String PARSER_FULL_AI_UPDATE_SNIPPET = "PARSER_FULL_AI_UPDATE_SNIPPET";
    private static final String PARSER_FULL_AI_UPDATE_ACTION = "PARSER_FULL_AI_UPDATE_ACTION";
    private static final String PARSER_FULL_AI_GHERKIN_SCENARIOS = "PARSER_FULL_AI_GHERKIN_SCENARIOS";

    public String getGherkinTestScenariosGenerationTemplate(String javaSource) {
        return String.format(prompts().get(PARSER_FULL_AI_GHERKIN_SCENARIOS),
                PromptUtils.cleanJavaCode(javaSource));
    }

    public String getUpdateUiActionTemplate(String currentDomState,
            String uiAction) {
        return String.format(prompts().get(PARSER_FULL_AI_UPDATE_ACTION),
                PromptUtils.cleanHtml(currentDomState), uiAction);
    }

    public String getUiActionJsSnippetGenerationTemplate(String currentDomState,
            String uiAction) {
        return String.format(prompts().get(PARSER_FULL_AI_UPDATE_SNIPPET),
                PromptUtils.cleanHtml(currentDomState), uiAction);
    }
}
