import com.vaadin.uitest.common.BasePlayWrightIT;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;
import static com.microsoft.playwright.assertions.PlaywrightAssertions.assertThat;

public class HelloWorldViewIT extends BasePlayWrightIT {

    @Override
    public String getUrl() {
        return "http://localhost:8080/hello";
    }

    @BeforeEach
    public void setupTest() throws Exception {
        super.setupTest();
        Locator loginField = page.locator("#login");
        Locator passwordField = page.locator("#pass");
        Locator loginButton = page.locator("vaadin-button:has-text('Login')");
        fill(loginField, "user");
        fill(passwordField, "password");
        click(loginButton);
        page.waitForTimeout(50);
    }

    @Test
    public void initialUIState() throws Exception {
        // Given the user is on the HelloWorldView
        page.waitForSelector("vaadin-grid");
        // Then the user should see a text field with css selector "#input-vaadin-text-field-4"
        Locator textField = page.locator("#input-vaadin-text-field-4");
        assertThat(textField.count()).isGreaterThan(0);
        // And the user should see a button with css selector "vaadin-button"
        Locator button = page.locator("vaadin-button");
        assertThat(button.count()).isGreaterThan(0);
    }

    @Test
    public void userEntersName() throws Exception {
        // Given the user is on the HelloWorldView
        page.waitForSelector("vaadin-grid");
        // When the user enters "John" into the text field with css selector "#input-vaadin-text-field-4"
        Locator textField = page.locator("#input-vaadin-text-field-4");
        fill(textField, "John");
        // Then the value of the text field with css selector "#input-vaadin-text-field-4" should be "John"
        assertEquals("John", textField.inputValue());
    }

    @Test
    public void userClicksOnSayHelloButton() throws Exception {
        // Given the user is on the HelloWorldView
        page.waitForSelector("vaadin-grid");
        // And the user has entered "John" into the text field with css selector "#input-vaadin-text-field-4"
        Locator textField = page.locator("#input-vaadin-text-field-4");
        fill(textField, "John");
        // When the user clicks on the button with css selector "vaadin-button"
        Locator button = page.locator("vaadin-button");
        click(button);
        // Then a notification should appear with the text "Hello John"
        Locator notification = page.locator("vaadin-notification-card:has-text('Hello John')");
        assertThat(notification.count()).isGreaterThan(0);
    }

    @Test
    public void userPressesEnterKey() throws Exception {
        // Given the user is on the HelloWorldView
        page.waitForSelector("vaadin-grid");
        // And the user has entered "John" into the text field with css selector "#input-vaadin-text-field-4"
        Locator textField = page.locator("#input-vaadin-text-field-4");
        fill(textField, "John");
        // When the user presses the enter key
        press(textField, "Enter");
        // Then a notification should appear with the text "Hello John"
        Locator notification = page.locator("vaadin-notification-card:has-text('Hello John')");
        assertThat(notification.count()).isGreaterThan(0);
    }

    @Test
    public void userNavigatesToAnotherView() throws Exception {
        // Given the user is on the HelloWorldView
        page.waitForSelector("vaadin-grid");
        // When the user clicks on the side-nav-item with path "about"
        Locator aboutNavItem = page.locator("side-nav-item[path='about']");
        click(aboutNavItem);
        // Then the HelloWorldView should be removed from the DOM
        Locator helloWorldView = page.locator("HelloWorldView");
        assertThat(helloWorldView.count()).isEqualTo(0);
        // And the AboutView should be added to the DOM
        Locator aboutView = page.locator("AboutView");
        assertThat(aboutView.count()).isGreaterThan(0);
    }

    @Test
    public void userReturnsToHelloWorldView() throws Exception {
        // Given the user is on the AboutView
        page.waitForSelector("vaadin-grid");
        Locator aboutNavItem = page.locator("side-nav-item[path='about']");
        click(aboutNavItem);
        // When the user clicks on the side-nav-item with path "hello"
        Locator helloNavItem = page.locator("side-nav-item[path='hello']");
        click(helloNavItem);
        // Then the AboutView should be removed from the DOM
        Locator aboutView = page.locator("AboutView");
        assertThat(aboutView.count()).isEqualTo(0);
        // And the HelloWorldView should be added to the DOM
        Locator helloWorldView = page.locator("HelloWorldView");
        assertThat(helloWorldView.count()).isGreaterThan(0);
        // And the user should see a text field with css selector "#input-vaadin-text-field-4"
        Locator textField = page.locator("#input-vaadin-text-field-4");
        assertThat(textField.count()).isGreaterThan(0);
        // And the user should see a button with css selector "vaadin-button"
        Locator button = page.locator("vaadin-button");
        assertThat(button.count()).isGreaterThan(0);
    }

    // Implement other test methods following the same pattern as above
}
