import com.microsoft.playwright.*;
import org.junit.jupiter.api.*;

import static org.junit.jupiter.api.Assertions.*;

public class HelloWorldViewTest {
    private static Browser browser;
    private Page page;

    @BeforeAll
    public static void setUp() {
        browser = Playwright.create().chromium().launch();
    }

    @BeforeEach
    public void beforeEach() {
        page = browser.newPage();
        page.navigate("http://localhost:8080/hello");
    }

    @AfterEach
    public void afterEach() {
        page.close();
    }

    @AfterAll
    public static void tearDown() {
        browser.close();
    }

    @Test
    public void testInitialUIState() {
        assertNotNull(page.locator("#input-vaadin-text-field-4"));
        assertNotNull(page.locator("vaadin-button"));
    }

    @Test
    public void testUserEntersName() {
        page.locator("#input-vaadin-text-field-4").locator("input").fill("John");
        assertEquals("John", page.locator("#input-vaadin-text-field-4").locator("input").inputValue());
    }

    @Test
    public void testUserClicksOnSayHelloButton() {
        page.locator("#input-vaadin-text-field-4").locator("input").fill("John");
        page.locator("vaadin-button").click();
        page.waitForTimeout(500);
        assertEquals("Hello John", page.locator("vaadin-notification-card").textContent());
    }

    @Test
    public void testUserPressesEnterKey() {
        page.locator("#input-vaadin-text-field-4").locator("input").fill("John");
        page.keyboard().press("Enter");
        page.waitForTimeout(500);
        assertEquals("Hello John", page.locator("vaadin-notification-card").textContent());
    }

    @Test
    public void testUserNavigatesToAnotherView() {
        page.locator("side-nav-item[path='about']").click();
        page.waitForTimeout(500);
        assertEquals(0, page.locator("HelloWorldView").count());
        assertNotEquals(0, page.locator("AboutView").count());
    }

    @Test
    public void testUserReturnsToHelloWorldView() {
        page.locator("side-nav-item[path='hello']").click();
        page.waitForTimeout(500);
        assertEquals(0, page.locator("AboutView").count());
        assertNotEquals(0, page.locator("HelloWorldView").count());
        assertNotNull(page.locator("#input-vaadin-text-field-4"));
        assertNotNull(page.locator("vaadin-button"));
    }
}
