import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.Route;

@SuppressWarnings("serial")
@Route(value = "my-view", layout = MyLayout.class)
@Tag("my-view")
public class MyView extends Component implements HasComponents {

    @Tag("my-component")
    public static class MyComponent<T> extends Component {
        final String label;
        public MyComponent() {
            label = null;
        }
        public MyComponent(String fooParameter) {
            this.label = fooParameter;
        }
    }

    public static class MyComposite extends Composite<MyComponent<Div>> {
    }

    private MyComponent<Div> state = new MyComponent<>("BAR");
    private TextField field = new TextField("FOO");
    private Span span1 = new Span();

    public MyView() {
        MyComponent<Div> box2 = new MyComponent<>("BAR2");
        TextField field2 = new TextField("FOO2");
        Span span2 = new Span();
        MyComposite composite = new MyComposite();

        add(state, field, box2, field2, span1, span2, composite);
        // Duplicate add call
        add(span1);
        // Component created in method return
        add(createInReturn());
        // Component created in method
        add(createInMethod());
        // Component created in nested method
        add(createInNestedMethod());
        // Component created in more nested method
        add(createInMoreNestedMethod());
    }

    private Div createInMethod() {
        Div div = new Div();
        return div;
    }

    private Div createInMoreNestedMethod() {
        return createInNestedMethod();
    }

    private Div createInNestedMethod() {
        return createInReturn();
    }

    private Div createInReturn() {
        return new Div();
    }
}
