import { defineConfig, devices } from '@playwright/test';

const isMaven = !!process.env.MAVEN_CMD_LINE_ARGS;

/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// require('dotenv').config();

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  testDir: 'src/test/frontend',
  outputDir: './target/playwright-reports/tests',
  /* Run tests in files in parallel */
  fullyParallel: true,
  /* Fail the build on CI if you accidentally left test.only in the source code. */
  forbidOnly: isMaven,
  /* Retry on CI only */
  retries: isMaven ? 2 : 0,
  /* Opt out of parallel tests on CI. */
  workers: isMaven ? 1 : undefined,
  /* Reporter to use. See https://playwright.dev/docs/test-reporters */
  reporter: [
    ['html', { outputFolder: 'target/playwright-reports/html', open: !isMaven }],
    ['junit', { outputFile: 'target/playwright-reports/TEST-frontend-report.xml' }]
  ],
  /* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
  use: {
    /* Base URL to use in actions like `await page.goto('/')`. */
    baseURL: 'http://localhost:8080/',
    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: 'on-first-retry',
  },

  /* Configure projects for major browsers */
  projects: [
    {
      name: 'chromium',
      use: { ...devices['Desktop Chrome'] },
    },

    // {
    //   name: 'firefox',
    //   use: { ...devices['Desktop Firefox'] },
    // },

    // {
    //   name: 'webkit',
    //   use: { ...devices['Desktop Safari'] },
    // },

    /* Test against mobile viewports. */
    // {
    //   name: 'Mobile Chrome',
    //   use: { ...devices['Pixel 5'] },
    // },
    // {
    //   name: 'Mobile Safari',
    //   use: { ...devices['iPhone 12'] },
    // },

    /* Test against branded browsers. */
    // {
    //   name: 'Microsoft Edge',
    //   use: { ...devices['Desktop Edge'], channel: 'msedge' },
    // },
    // {
    //   name: 'Google Chrome',
    //   use: { ...devices['Desktop Chrome'], channel: 'chrome' },
    // },
  ],

  /* Uncomment these lines to run your local dev server before starting the tests */
  // webServer: {
  //  command: "mvn-B -ntp -Dspring-boot.run.jvmArguments='-Dvaadin.launch-browser=false'",
  //  url: "http://localhost:8080/",
  //  reuseExistingServer: isMaven,
  //  stdout: "pipe",
  //  stderr: "pipe",
  //},
});
