package com.vaadin.uitest.model.flow;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.listbox.ListBox;
import com.vaadin.flow.component.listbox.MultiSelectListBox;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.sidenav.SideNav;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.component.virtuallist.VirtualList;

import java.util.Arrays;

public enum FlowComponent {

    BUTTON(Button.class, "vaadin-button"),

    CHECKBOX(Checkbox.class, "vaadin-checkbox"),

    CHECKBOX_GROUP(CheckboxGroup.class, "vaadin-checkbox-group"),

    COMBO_BOX(ComboBox.class, "vaadin-combo-box"),

    CONFIRM_DIALOG(ConfirmDialog.class, "vaadin-confirm-dialog"),

    DATE_PICKER(DatePicker.class, "vaadin-date-picker"),

    DATE_TIME_PICKER(DateTimePicker.class, "vaadin-date-time-picker"),

    DIALOG(Dialog.class, "vaadin-dialog"),

    EMAIL_FIELD(EmailField.class, "vaadin-email-field"),

    GRID(Grid.class, "vaadin-grid"),

    INTEGER_FIELD(IntegerField.class, "vaadin-integer-field"),

    LIST_BOX(ListBox.class, "vaadin-list-box"),

    MENU_BAR(MenuBar.class, "vaadin-menu-bar"),

    MULTI_SELECT_COMBO_BOX(MultiSelectComboBox.class,
            "vaadin-multi-select-combo-box"),

    MULTI_SELECT_LIST_BOX(MultiSelectListBox.class,
            "vaadin-multi-select-list-box"),

    NOTIFICATION(Notification.class, "vaadin-notification"),

    NUMBER_FIELD(NumberField.class, "vaadin-number-field"),

    PASSWORD_FIELD(PasswordField.class, "vaadin-password-field"),

    RADIO_BUTTON_GROUP(RadioButtonGroup.class, "vaadin-radio-button-group"),

    SELECT(Select.class, "vaadin-select"),

    SIDE_NAV(SideNav.class, "vaadin-side-nav"),

    TABS(Tabs.class, "vaadin-tabs"),

    TEXT_AREA(TextArea.class, "vaadin-text-area"),

    TEXT_FIELD(TextField.class, "vaadin-text-field"),

    TIME_PICKER(TimePicker.class, "vaadin-time-picker"),

    VIRTUAL_LIST(VirtualList.class, "vaadin-virtual-list"),

    UNKNOWN(null, null);

    private final Class<? extends Component> componentClass;
    private final String componentTag;

    FlowComponent(Class<? extends Component> componentClass,
            String componentTag) {
        this.componentClass = componentClass;
        this.componentTag = componentTag;
    }

    public Class<? extends Component> getComponentClass() {
        return componentClass;
    }

    public String getComponentTag() {
        return componentTag;
    }

    public String getSimpleName() {
        return componentClass.getSimpleName();
    }

    public static FlowComponent getByComponentClass(
            Class<? extends Component> componentClass) {
        return Arrays.stream(values()).filter(
                component -> component.componentClass.equals(componentClass))
                .findAny().orElse(null);
    }

    public static FlowComponent getByComponentSimpleName(
            String componentSimpleName) {
        return Arrays
                .stream(values()).filter(component -> component.componentClass
                        .getSimpleName().equals(componentSimpleName))
                .findAny().orElse(null);
    }

    public static FlowComponent getByName(String name) {
        return Arrays.stream(values())
                .filter(component -> component.name().equals(name)).findAny()
                .orElse(null);
    }

    public static FlowComponent getCorrespondingComponent(
            FlowComponentElement element) {
        return getByName(element.name());
    }
}
