package com.vaadin.uitest.model.flow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class FlowCodeSample {

    private final String code;
    private final FlowComponent primaryFlowComponent;
    private String description;
    private Map<String, String> additionalParameters;
    private Set<FlowComponent> additionalFlowComponents;

    public FlowCodeSample(FlowComponent primaryFlowComponent, String code) {
        this.primaryFlowComponent = primaryFlowComponent;
        this.code = code;
    }

    public FlowComponent getPrimaryFlowComponent() {
        return primaryFlowComponent;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    // Shortened name for "getAdditionalParameter"
    public String get(String key) {
        return additionalParameters == null ? null
                : additionalParameters.get(key);
    }

    public Map<String, String> getAdditionalParameters() {
        return additionalParameters == null ? Collections.emptyMap()
                : Map.copyOf(additionalParameters);
    }

    public boolean hasAdditionalParameter(String key) {
        return additionalParameters != null
                && additionalParameters.containsKey(key);
    }

    public void setAdditionalParameters(
            Map<String, String> additionalParameters) {
        if (additionalParameters == null || additionalParameters.isEmpty()) {
            this.additionalParameters = null;
        } else {
            this.additionalParameters = Map.copyOf(additionalParameters);
        }
    }

    public Set<FlowComponent> getAdditionalFlowComponents() {
        return additionalFlowComponents == null ? Collections.emptySet()
                : Set.copyOf(additionalFlowComponents);
    }

    public boolean hasAdditionalFlowComponents(FlowComponent flowComponent) {
        return additionalFlowComponents != null
                && additionalFlowComponents.contains(flowComponent);
    }

    public void setAdditionalFlowComponents(
            Set<FlowComponent> additionalFlowComponents) {
        if (additionalFlowComponents == null
                || additionalFlowComponents.isEmpty()) {
            this.additionalFlowComponents = null;
        } else {
            this.additionalFlowComponents = Set
                    .copyOf(additionalFlowComponents);
        }
    }
}
